function getAngleDeg(ax,ay,bx,by) {
	var angleRad = JavaMath.atan2((ay-by), (ax-bx));
	var angleDeg = angleRad * 180 / JavaMath.PI;
	return(angleDeg);
}

onEvent('entity.death', event => {

	if (event.entity.isPlayer()) {
		event.entity.player.data.deathCoords = [event.entity.player.x.valueOf(), event.entity.player.y.valueOf(), event.entity.player.z.valueOf()]
		event.entity.player.data.secondsToDespawn = 180*20
	}

});

onEvent('player.tick', event => {

	if (event.player.data.secondsToDespawn >= 0) {
		event.player.data.distanceToCoords = parseInt(event.entity.getDistance(event.player.data.deathCoords[0], event.player.data.deathCoords[1], event.player.data.deathCoords[2]).toFixed())
		if (event.player.data.distanceToCoords >= 10 && event.player.isAlive()) {
			let angleToCoords = getAngleDeg(event.player.x, event.player.z, +event.player.data.deathCoords[0], +event.player.data.deathCoords[2]) - event.player.yaw + 90
			const directions = ['⬆', '⬈', '➡', '⬊', '⬇', '⬋', '⬅', '⬉', '⬆', '⬈', '➡']
			let compassMarker = directions[0]
			if (angleToCoords >= 0) { compassMarker = directions[JavaMath.floor((angleToCoords+22.5)/45)] }
			else { compassMarker = directions[JavaMath.floor((angleToCoords+22.5)/45) + 8] }
			event.player.setStatusMessage(Component.join(Component.string('   '), [
				Component.white(` 距离死亡 位置 ${event.player.data.distanceToCoords} 个方块`),
				Component.white(compassMarker),
				Component.red('['.concat(new Date(event.player.data.secondsToDespawn / 20 * 1000).toISOString().substring(14, 19), ']'))]))
		}
		if (event.player.data.distanceToCoords < 10 && event.player.isAlive()) {
			event.player.data.secondsToDespawn = 0
		}

		event.player.data.secondsToDespawn -= 1

	}

});