

function castPentagram(pos, particle, radius){
    let heightOffset = -0.9; // in case you want it above you
    let pc = [];

    for (let i = 0; i < 360; i++) {
        // let prot = p.yaw - 90;
        let tangle = i * JavaMath.PI / 180;
        let d = vectors(tangle, radius, pos);
        // p.world.spawnParticle(desiredParticle, d[0], p.getY() + heightOffset, d[1], 0, 0, 0, 0, 0);
        particle.cast({x:d[0], y:pos.y+heightOffset, z:d[1], level: {dimension: 'minecraft:the_end'}})
        if (i == 0) pc.push({ x: d[0], y: pos.y, z: d[1] });
        if (i == 72) pc.push({ x: d[0], y: pos.y, z: d[1] });
        if (i == 144) pc.push({ x: d[0], y: pos.y, z: d[1] });
        if (i == 216) pc.push({ x: d[0], y: pos.y, z: d[1] });
        if (i == 288) pc.push({ x: d[0], y: pos.y, z: d[1] });

    }
    particle.xOffset = 0
    particle.zOffset = 0
    // particle.debug = true
    drawLine(particle, pc[0].x, pc[0].y+heightOffset, pc[0].z, pc[2].x, pc[2].y+heightOffset, pc[2].z, 10);
    drawLine(particle, pc[4].x, pc[4].y+heightOffset, pc[4].z, pc[1].x, pc[1].y+heightOffset, pc[1].z, 10);
    drawLine(particle, pc[4].x, pc[4].y+heightOffset, pc[4].z, pc[2].x, pc[2].y+heightOffset, pc[2].z, 10);
    drawLine(particle, pc[0].x, pc[0].y+heightOffset, pc[0].z, pc[3].x, pc[3].y+heightOffset, pc[3].z, 10);
    drawLine(particle, pc[3].x, pc[3].y+heightOffset, pc[3].z, pc[1].x, pc[1].y+heightOffset, pc[1].z, 10);

}

function castParticleBall(pos, particle, radius){
    let heightOffset = 0.5; // in case you want it above you
    let resolution = 10 //resolution of the line

    for (let i = 0; i <= 360; i += resolution) {
        let horizontalAngle = i * JavaMath.PI / 180;

        for (let j = 0; j <= 180; j += resolution) {
            let verticalAngle = j * JavaMath.PI / 180;
            let d = Dvectors(horizontalAngle, verticalAngle, radius, pos);
            particle.hSpread = 0.5
            particle.vSpread = 0.5
            particle.cast({x:d[0], y:pos.y + heightOffset + d[1], z:d[2], level: {dimension: 'minecraft:the_end'}})
        }
    }
}



function drawLine(particle, x1, y1, z1, x2, y2, z2, resolution) {
    let dx = x2 - x1;
    let dy = y2 - y1;
    let dz = z2 - z1;
    let drawAmount = Math.ceil(Math.sqrt(dx * dx + dy * dy + dz * dz) * resolution);
    for (let i = 0; i < drawAmount; i++) {
        let x = (x1 + dx * (i / drawAmount)).toFixed(4);
        let y = (y1 + dy * (i / drawAmount)).toFixed(4);
        let z = (z1 + dz * (i / drawAmount)).toFixed(4);
        let output = particle.cast({x:x, y:y, z:z, level: {dimension: 'minecraft:the_end'}})
    }

}


