const replaceIngredients = [
    ['botania:manaweave_helmet', 'minecraft:leather_helmet'],
    ['botania:manaweave_chestplate', 'minecraft:leather_chestplate'],
    ['botania:manaweave_leggings', 'minecraft:leather_leggings'],
    ['botania:manasteel_shovel', 'minecraft:iron_shovel'],
    ['botania:manasteel_pick', 'minecraft:iron_pickaxe'],
    ['botania:manasteel_axe', 'minecraft:iron_axe'],
    ['botania:manasteel_sword', 'minecraft:iron_sword'],
    ['botania:manasteel_helmet', 'minecraft:iron_helmet'],
    ['botania:manasteel_chestplate', 'minecraft:iron_chestplate'],
    ['botania:manasteel_leggings', 'minecraft:iron_leggings'],
    ['botania:manasteel_boots', 'minecraft:gold_boots'],
    ['botania:manasteel_shovel', 'minecraft:gold_shovel'],
    ['botania:manasteel_pick', 'minecraft:gold_pickaxe'],
    ['botania:manasteel_axe', 'minecraft:gold_axe'],
    ['botania:manasteel_sword', 'minecraft:gold_sword'],
    ['botania:manasteel_helmet', 'minecraft:gold_helmet'],
    ['botania:manasteel_chestplate', 'minecraft:gold_chestplate'],
    ['botania:manasteel_leggings', 'minecraft:gold_leggings'],
    ['botania:manasteel_boots', 'minecraft:gold_boots'],
    ['botania:elementium_shovel', 'minecraft:diamond_shovel'],
    ['botania:elementium_pickaxe', 'minecraft:diamond_pickaxe'],
    ['botania:elementium_axe', 'minecraft:diamond_axe'],
    ['botania:elementium_sword', 'minecraft:diamond_sword'],
    ['botania:elementium_helmet', 'minecraft:diamond_helmet'],
    ['botania:elementium_chestplate', 'minecraft:diamond_chestplate'],
    ['botania:elementium_leggings', 'minecraft:diamond_leggings'],
    ['botania:elementium_boots', 'minecraft:diamond_boots'],
    ['botania:terra_shovel', 'minecraft:netherite_shovel'],
    ['botania:terra_pick', 'minecraft:netherite_pickaxe'],
    ['botania:terra_axe', 'minecraft:netherite_axe'],
    ['botania:terra_sword', 'minecraft:netherite_sword'],
    ['botania:terrasteel_helmet', 'minecraft:netherite_helmet'],
    ['botania:terrasteel_chestplate', 'minecraft:netherite_chestplate'],
    ['botania:terrasteel_leggings', 'minecraft:netherite_leggings'],
    ['botania:terrasteel_boots', 'minecraft:netherite_boots'],
    
 
]
onEvent('recipes', event => {

    event.shapeless('minecraft:book', ['minecraft:string', 'minecraft:paper', 'minecraft:paper', 'minecraft:paper']).id('ftbai:book')

    event.smelting('minecraft:gold_ingot', 'minecraft:raw_gold')
    event.recipes.bloodmagic.array('minecraft:gold_ingot', 'minecraft:iron_ingot', 'naturesaura:gold_powder').texture("bloodmagic:textures/models/alchemyarrays/suppressionsigil.png").id('ftbai:alchemical_gold_ingot')
    event.custom({
        "type": "naturesaura:altar",
        "input": {
            "item": "rootsclassic:old_root"
        },
        "output": {
            "item": "minecraft:sugar_cane"
        },
        "aura_type": "naturesaura:overworld",
        "aura": 10000,
        "time": 50
    })
    event.shapeless('minecraft:white_carpet', ['#minecraft:carpets', 'supplementaries:soap']).id('supplementaries:soap/carpet')
    event.shaped('minecraft:furnace', ['CCC', 'C C', 'CCC'], {C: 'minecraft:cobblestone'}).id('minecraft:furnace')

    replaceIngredients.forEach(map =>{
        console.log('Replacing ' + map[1] + ' with ' + map[0])
        let output = map[0]
        let input = map[1]
        event.replaceInput({type: 'minecraft:crafting_shapeless'},input, output)
        event.replaceOutput({type: 'minecraft:crafting_shapeless'},input, output)
        event.replaceInput({type: 'minecraft:crafting_shaped'},input, output)
        event.replaceOutput({type: 'minecraft:crafting_shaped'},input, output)
    })

    event.shaped('apotheosis:salvaging_table', ['CCC', 'PSA', 'GLG'], {
        C: '#forge:ingots/copper',
        G: 'apotheosis:gem_dust',
        S: 'minecraft:smithing_table',
        L: 'minecraft:lava_bucket',
        P: 'botania:manasteel_pick',
        A: 'botania:manasteel_axe'
    }).id('apotheosis:salvaging_table')
    event.stonecutting('minecraft:stone', 'minecraft:smooth_stone')
    event.stonecutting('minecraft:smooth_stone', 'minecraft:stone')
    event.remove({id: 'constructionwand:core_destruction'})
    event.shaped('constructionwand:core_destruction', [' GP', 'GBG', 'PG '], {
        G: '#forge:glass_panes',
        P: 'botania:elementium_pickaxe',
        B: 'occultism:spirit_attuned_crystal'}).id('constructionwand:core_destruction')
    event.remove({id: 'chipped:benches/carpenters_table'})
    event.shaped('chipped:carpenters_table', ['  I', 'LTL', 'APL'], {
        I: 'minecraft:iron_ingot',
        L: '#minecraft:logs',
        T: 'minecraft:crafting_table',
        A: Item.of('botania:manasteel_pick').ignoreNBT(),
        P: '#minecraft:planks'}).id('chipped:benches/carpenters_table').damageIngredient(Item.of('botania:manasteel_pick').ignoreNBT())
        event.remove({id: 'iceandfire:gravel'})
        event.shapeless('minecraft:gravel', ['#iceandfire:crackled_block','#iceandfire:crackled_block','#iceandfire:crackled_block']).id('iceandfire:gravel')
})