/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.features.loot;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.TypeAdapterFactory;
import dev.ftb.packcompanion.registry.LootTableRegistries;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.LowerCaseEnumTypeAdapterFactory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomNameLootFunction
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomNameLootFunction.class);
    private static final Random RANDOM_SOURCE = new Random();
    private static final Gson GSON = (Gson)Util.m_137537_(() -> {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.disableHtmlEscaping();
        gsonBuilder.registerTypeHierarchyAdapter(Component.class, (Object)new Component.Serializer());
        gsonBuilder.registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory());
        return gsonBuilder.create();
    });
    private static Map<String, List<Component>> namingData = null;
    private static boolean hasAttemptedLoad = false;
    final String nameSetKey;

    RandomNameLootFunction(LootItemCondition[] lootItemConditions, @Nullable String arg) {
        super(lootItemConditions);
        this.nameSetKey = arg;
    }

    public static void clearCache() {
        LOGGER.debug("Clearing RandomNameLootFunction source data");
        namingData = null;
        hasAttemptedLoad = false;
    }

    protected ItemStack m_7372_(ItemStack itemStack, LootContext lootContext) {
        Resource namingSource;
        if (this.nameSetKey == null) {
            return itemStack;
        }
        try {
            namingSource = lootContext.m_78952_().m_142572_().m_177941_().m_142591_(new ResourceLocation("ftbpc", "sources/random-name-loot-source.json"));
        }
        catch (IOException e) {
            LOGGER.warn("Attempted RandomNameLootFunction with no random-name-loot-source.json file in the data/ftbpc/sources folder", (Throwable)e);
            return itemStack;
        }
        if (hasAttemptedLoad && namingData == null) {
            LOGGER.warn("Attempted to load naming data for RandomNameLootFunction but no data was found");
            return itemStack;
        }
        if (namingData == null) {
            hasAttemptedLoad = true;
            try (InputStreamReader reader = new InputStreamReader(namingSource.m_6679_());){
                namingData = (Map)GSON.fromJson((Reader)reader, new TypeToken<Map<String, List<Component>>>(){}.getType());
            }
            catch (Exception e) {
                LOGGER.error("Error trying to read", (Throwable)e);
            }
        }
        if (!namingData.containsKey(this.nameSetKey)) {
            LOGGER.warn("Attempted to use RandomNameLootFunction without supplying a valid name for the file lookup");
            return itemStack;
        }
        List<Component> names = namingData.get(this.nameSetKey);
        Component nameToUse = names.get(RANDOM_SOURCE.nextInt(names.size()));
        itemStack.m_41714_(nameToUse);
        return itemStack;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)LootTableRegistries.RANDOM_NAME_LOOT_FUNCTION.get();
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RandomNameLootFunction> {
        public void serialize(JsonObject jsonObject, RandomNameLootFunction arg, JsonSerializationContext jsonSerializationContext) {
            super.m_6170_(jsonObject, (LootItemConditionalFunction)arg, jsonSerializationContext);
            if (arg.nameSetKey != null) {
                jsonObject.addProperty("nameSetKey", arg.nameSetKey);
            }
        }

        public RandomNameLootFunction deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] args) {
            return new RandomNameLootFunction(args, jsonObject.get("nameSetKey").getAsString());
        }
    }
}

