/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.ftb.packcompanion.commands.CommandEntry;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class PlaceJigsawCommand
implements CommandEntry {
    private static final SimpleCommandExceptionType ERROR_JIGSAW_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.place.jigsaw.failed"));
    private static final DynamicCommandExceptionType ERROR_INVALID_TEMPLATE_POOL = new DynamicCommandExceptionType(arg -> new TranslatableComponent("commands.place.jigsaw.invalid", new Object[]{arg}));

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"place_jigsaw").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82129_((String)"pool", (ArgumentType)ResourceKeyArgument.m_212386_((ResourceKey)Registry.f_122884_)).then(Commands.m_82129_((String)"target", (ArgumentType)ResourceLocationArgument.m_106984_()).then(Commands.m_82129_((String)"max_depth", (ArgumentType)IntegerArgumentType.integer((int)1, (int)7)).then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> PlaceJigsawCommand.placeJigsaw((CommandSourceStack)ctx.getSource(), PlaceJigsawCommand.getStructureTemplatePool((CommandContext<CommandSourceStack>)ctx, "pool"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"target"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"max_depth"), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"position")))))))).then(Commands.m_82129_((String)"pool", (ArgumentType)ResourceKeyArgument.m_212386_((ResourceKey)Registry.f_122884_)).then(Commands.m_82129_((String)"target", (ArgumentType)ResourceLocationArgument.m_106984_()).then(Commands.m_82129_((String)"max_depth", (ArgumentType)IntegerArgumentType.integer((int)1, (int)7)).executes(ctx -> PlaceJigsawCommand.placeJigsaw((CommandSourceStack)ctx.getSource(), PlaceJigsawCommand.getStructureTemplatePool((CommandContext<CommandSourceStack>)ctx, "pool"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"target"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"max_depth"), new BlockPos(((CommandSourceStack)ctx.getSource()).m_81371_()))))));
    }

    public static int placeJigsaw(CommandSourceStack source, Holder<StructureTemplatePool> pool, ResourceLocation target, int maxDepth, BlockPos position) throws CommandSyntaxException {
        return PlaceJigsawCommand.placeJigsaw(source, source.m_81372_(), ((ResourceKey)pool.m_203543_().orElseThrow()).m_135782_(), target, maxDepth, position);
    }

    public static int placeJigsaw(CommandSourceStack source, ServerLevel level, ResourceLocation pool, ResourceLocation target, int maxDepth, BlockPos position) throws CommandSyntaxException {
        BlockState prevState = level.m_8055_(position);
        level.m_7731_(position, Blocks.f_50678_.m_49966_(), 0);
        BlockEntity blockEntity = level.m_7702_(position);
        if (blockEntity instanceof JigsawBlockEntity) {
            JigsawBlockEntity jbe = (JigsawBlockEntity)blockEntity;
            jbe.m_59440_(pool);
            jbe.m_59438_(target);
            jbe.m_59420_(level, maxDepth, false);
            if (level.m_8055_(position).m_60734_() != Blocks.f_50678_) {
                source.m_81354_((Component)new TranslatableComponent("commands.place.jigsaw.success", new Object[]{position.m_123341_(), position.m_123342_(), position.m_123343_()}), false);
                return 1;
            }
        }
        level.m_7731_(position, prevState, 0);
        throw ERROR_JIGSAW_FAILED.create();
    }

    private static <T> ResourceKey<T> getRegistryType(CommandContext<CommandSourceStack> ctx, String name, ResourceKey<Registry<T>> key, DynamicCommandExceptionType exceptionType) throws CommandSyntaxException {
        ResourceKey resourcekey = (ResourceKey)ctx.getArgument(name, ResourceKey.class);
        Optional optional = resourcekey.m_195975_(key);
        return (ResourceKey)optional.orElseThrow(() -> exceptionType.create((Object)resourcekey));
    }

    private static <T> Registry<T> getRegistry(CommandContext<CommandSourceStack> ctx, ResourceKey<? extends Registry<T>> key) {
        return ((CommandSourceStack)ctx.getSource()).m_81377_().m_206579_().m_175515_(key);
    }

    private static <T> Holder<T> getRegistryKeyType(CommandContext<CommandSourceStack> ctx, String name, ResourceKey<Registry<T>> key, DynamicCommandExceptionType exceptionType) throws CommandSyntaxException {
        ResourceKey resourcekey = PlaceJigsawCommand.getRegistryType(ctx, name, key, exceptionType);
        return (Holder)PlaceJigsawCommand.getRegistry(ctx, key).m_203636_(resourcekey).orElseThrow(() -> exceptionType.create((Object)resourcekey.m_135782_()));
    }

    public static Holder<StructureTemplatePool> getStructureTemplatePool(CommandContext<CommandSourceStack> ctx, String name) throws CommandSyntaxException {
        return PlaceJigsawCommand.getRegistryKeyType(ctx, name, Registry.f_122884_, ERROR_INVALID_TEMPLATE_POOL);
    }
}

