/*
 * Decompiled with CFR 0.152.
 */
package forge.top.vmctcn.vmtranslationupdate.util;

import forge.top.vmctcn.vmtranslationupdate.VMTranslationUpdate;
import forge.top.vmctcn.vmtranslationupdate.util.ModConfigUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;

public class PackDownloadUtil {
    public static final Minecraft client = Minecraft.m_91087_();
    public static final Path resourcePackDir = client.m_91101_().toPath();
    public static String resourcePackName = ModConfigUtil.getConfig().traslationPackName + ".zip";
    private static Path resPackFilePath = resourcePackDir.resolve(resourcePackName);

    public static void downloadResPack() {
        if (!Files.isDirectory(resourcePackDir, new LinkOption[0])) {
            try {
                Files.createDirectories(resourcePackDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            PackDownloadUtil.downloadResPackFile(resPackFilePath);
        }
        catch (Exception e) {
            VMTranslationUpdate.LOGGER.warn("Failed to download \"%s\" resource pack.", (Object)resourcePackName.getBytes(StandardCharsets.UTF_8));
            e.printStackTrace();
        }
        if (Files.exists(resPackFilePath, new LinkOption[0]) && ModConfigUtil.getConfig().autoInstallVMTranslationPack) {
            try {
                PackDownloadUtil.setResourcePack();
            }
            catch (Exception e) {
                VMTranslationUpdate.LOGGER.warn("Failed to set up \"%s\" resource pack.", (Object)resourcePackName.getBytes(StandardCharsets.UTF_8));
                e.printStackTrace();
            }
        }
    }

    public static void downloadResPackFile(Path savePath) throws IOException {
        URL url = new URL(ModConfigUtil.getConfig().traslationPackUrl + ModConfigUtil.getConfig().traslationPackName + ".zip");
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(10000);
        try (InputStream in = url.openStream();){
            Files.copy(in, savePath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void setResourcePack() {
        Minecraft client = Minecraft.m_91087_();
        Options gameOptions = client.f_91066_;
        if (!gameOptions.f_92117_.contains(resourcePackName)) {
            client.f_91066_.f_92117_.add(resourcePackName);
        } else {
            ArrayList<String> packs = new ArrayList<String>(100);
            packs.add(resourcePackName);
            packs.addAll(gameOptions.f_92117_);
            gameOptions.f_92117_ = packs;
        }
    }
}

