/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbjigsawhelper;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTBJigsawHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FTBJigsawHelper.class);
    public static final ResourceLocation emptyTemplatePool = new ResourceLocation("empty");

    public static void init(String initializer) {
        LOGGER.info("Initializing FTBJigsawHelper from {}", (Object)initializer);
    }

    public static Pair<Boolean, Component> fixArea(ServerLevel level, BlockPos start, BlockPos end, String find, String replace, boolean commit) {
        AABB bounds = new AABB(start, end);
        List<BlockPos> blocksInRegion = BlockPos.m_121921_((AABB)bounds).map(BlockPos::m_7949_).toList();
        HashMap<BlockPos, ResourceLocation> originalJigsawBlocks = new HashMap<BlockPos, ResourceLocation>();
        ArrayList<BlockPos> effectedBlocks = new ArrayList<BlockPos>();
        if (!find.isEmpty() && !replace.isEmpty()) {
            effectedBlocks.addAll(FTBJigsawHelper.updateBlocksInRegion(blocksInRegion, (Level)level, entity -> entity instanceof JigsawBlockEntity, (pos, entity) -> {
                if (!(entity instanceof JigsawBlockEntity)) {
                    return false;
                }
                JigsawBlockEntity jigsawBlockEntity = (JigsawBlockEntity)entity;
                ResourceLocation targetName = jigsawBlockEntity.m_59444_();
                if (targetName.equals((Object)emptyTemplatePool)) {
                    return false;
                }
                if (!commit) {
                    originalJigsawBlocks.put((BlockPos)pos, targetName);
                }
                String newPoolName = targetName.toString().replace(find, replace);
                jigsawBlockEntity.m_59440_(new ResourceLocation(newPoolName));
                jigsawBlockEntity.m_187480_();
                jigsawBlockEntity.m_6596_();
                level.m_7260_(pos, entity.m_58900_(), entity.m_58900_(), 2);
                return true;
            }));
        }
        effectedBlocks.addAll(FTBJigsawHelper.updateBlocksInRegion(blocksInRegion, (Level)level, entity -> entity instanceof StructureBlockEntity, (pos, entity) -> {
            if (!(entity instanceof StructureBlockEntity)) {
                return false;
            }
            StructureBlockEntity structureBlockEntity = (StructureBlockEntity)entity;
            String structureName = structureBlockEntity.m_59895_();
            if (!find.isEmpty() && !replace.isEmpty()) {
                String newStructureName = structureName.replace(find, replace);
                structureBlockEntity.m_59868_(newStructureName);
            }
            structureBlockEntity.m_59889_(true);
            if (!commit) {
                structureBlockEntity.m_59868_(structureName);
            }
            level.m_7260_(pos, entity.m_58900_(), entity.m_58900_(), 2);
            return true;
        }));
        if (!originalJigsawBlocks.isEmpty()) {
            originalJigsawBlocks.forEach((key, value) -> {
                BlockEntity blockEntity = level.m_7702_(key);
                if (blockEntity instanceof JigsawBlockEntity) {
                    JigsawBlockEntity jigsawBlockEntity = (JigsawBlockEntity)blockEntity;
                    jigsawBlockEntity.m_59440_(value);
                    jigsawBlockEntity.m_187480_();
                    level.m_7260_(key, jigsawBlockEntity.m_58900_(), jigsawBlockEntity.m_58900_(), 2);
                }
            });
        }
        return Pair.of((Object)true, (Object)new TextComponent("Updated " + effectedBlocks.size() + " blocks!"));
    }

    private static List<BlockPos> updateBlocksInRegion(List<BlockPos> blocksInRegion, Level level, Predicate<BlockEntity> isValid, BiFunction<BlockPos, BlockEntity, Boolean> action) {
        return blocksInRegion.stream().filter(pos -> {
            BlockEntity blockEntity = level.m_7702_(pos);
            return blockEntity != null && isValid.test(blockEntity);
        }).peek(pos -> {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity != null) {
                action.apply((BlockPos)pos, blockEntity);
            }
        }).toList();
    }
}

