/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbdungeons.util;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.utils.GameInstance;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonInstance;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ProgressiveJigsawPlacer {
    private static final Map<UUID, WorkData> pendingPlacements = new HashMap<UUID, WorkData>();

    public static void placeJigsaw(DungeonInstance dungeon, CommandSourceStack source, ServerLevel level, BlockPos position, BiConsumer<ServerPlayer, DungeonInstance> callback) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        DungeonType type = dungeon.type();
        level.m_7731_(position, (BlockState)Blocks.f_50678_.m_49966_().m_61124_((Property)JigsawBlock.f_54222_, (Comparable)type.jigsawOrientation()), 0);
        BlockEntity blockEntity = level.m_7702_(position);
        if (blockEntity instanceof JigsawBlockEntity) {
            JigsawBlockEntity jbe = (JigsawBlockEntity)blockEntity;
            jbe.m_59440_(type.templatePool());
            jbe.m_59438_(type.target());
            jbe.m_59424_(type.jointType());
            ProgressiveJigsawPlacer.scheduleGeneration(dungeon, player, level, jbe.m_58899_(), type.maxGenerationDepth(), callback);
        }
    }

    private static void scheduleGeneration(DungeonInstance dungeon, ServerPlayer player, ServerLevel pLevel, BlockPos origin, int maxDepth, BiConsumer<ServerPlayer, DungeonInstance> callback) {
        ChunkGenerator gen = pLevel.m_7726_().m_8481_();
        StructureManager structureManager = pLevel.m_8875_();
        Random random = pLevel.m_5822_();
        ArrayList pieces = Lists.newArrayList();
        StructureTemplate template = new StructureTemplate();
        template.m_163802_((Level)pLevel, origin, new Vec3i(1, 1, 1), false, null);
        SinglePoolElement element = new SinglePoolElement(template);
        PoolElementStructurePiece structurePiece = new PoolElementStructurePiece(structureManager, (StructurePoolElement)element, origin, 1, Rotation.NONE, new BoundingBox(origin));
        JigsawPlacement.m_210290_((RegistryAccess)pLevel.m_5962_(), (PoolElementStructurePiece)structurePiece, (int)maxDepth, PoolElementStructurePiece::new, (ChunkGenerator)gen, (StructureManager)structureManager, (List)pieces, (Random)random, (LevelHeightAccessor)pLevel);
        ArrayDeque<WorkUnit> units = new ArrayDeque<WorkUnit>(pieces.stream().map(p -> new WorkUnit(origin, (PoolElementStructurePiece)p)).toList());
        pendingPlacements.put(player.m_142081_(), new WorkData(dungeon, callback, pLevel, units.size(), units));
    }

    public static void tick() {
        HashSet toRemove = new HashSet();
        pendingPlacements.forEach((playerId, workData) -> {
            WorkUnit workUnit = workData.work().pollFirst();
            if (workUnit != null) {
                ServerLevel level = workData.level();
                if (level != null) {
                    StructureFeatureManager structurefeaturemanager = level.m_8595_();
                    ChunkGenerator chunkgenerator = level.m_7726_().m_8481_();
                    Random random = level.m_5822_();
                    workUnit.piece().m_192416_((WorldGenLevel)level, structurefeaturemanager, chunkgenerator, random, BoundingBox.m_71044_(), workUnit.pos(), false);
                    ServerPlayer player = GameInstance.getServer().m_6846_().m_11259_(playerId);
                    if (player != null) {
                        int pct = 100 - workData.work().size() * 100 / workData.size();
                        player.m_5661_((Component)new TranslatableComponent("ftbdungeons.messages.preparing", new Object[]{new TextComponent(pct + "%").m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.YELLOW), true);
                        if (workData.work().isEmpty()) {
                            toRemove.add(playerId);
                            workData.callback().accept(player, workData.dungeon());
                        }
                    }
                } else {
                    toRemove.add(playerId);
                }
            }
        });
        toRemove.forEach(pendingPlacements::remove);
    }

    private record WorkData(DungeonInstance dungeon, BiConsumer<ServerPlayer, DungeonInstance> callback, ServerLevel level, int size, Deque<WorkUnit> work) {
    }

    private record WorkUnit(BlockPos pos, PoolElementStructurePiece piece) {
    }
}

