/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbdungeons.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbdungeons.DungeonException;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import java.nio.file.Path;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;

public class DungeonUtils {
    public static final ResourceKey<Level> DUNGEON_DIMENSION = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("ftbdungeons", "dungeon_dim"));

    public static XZ spiralOut(int index) {
        if (index == 0) {
            return XZ.of((int)0, (int)0);
        }
        int x = 0;
        int z = 0;
        int dx = 0;
        int dz = 1;
        int segmentLength = 1;
        int segmentPassed = 0;
        for (int n = 0; n < index; ++n) {
            x += dx;
            z += dz;
            if (++segmentPassed != segmentLength) continue;
            segmentPassed = 0;
            int tmp = dz;
            dz = -dx;
            dx = tmp;
            if (dx != 0) continue;
            ++segmentLength;
        }
        return XZ.of((int)x, (int)z);
    }

    public static ServerLevel dungeonDimension(MinecraftServer server) {
        ServerLevel dungeonDim = server.m_129880_(DUNGEON_DIMENSION);
        if (dungeonDim == null) {
            throw new DungeonException("Dungeon dimension not loaded!");
        }
        return dungeonDim;
    }

    public static Component makeCommandClicky(String translationKey, ChatFormatting color, String command) {
        return new TextComponent("[").m_7220_((Component)new TranslatableComponent(translationKey).m_130948_(Style.f_131099_.m_131140_(color).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command)))).m_130946_("]");
    }

    @NotNull
    public static Component makeJoinDungeonClicky() {
        return DungeonUtils.makeCommandClicky("ftbdungeons.clicky.join", ChatFormatting.GREEN, "/ftbdungeons join");
    }

    public static Path levelKeyToPath(MinecraftServer server, ResourceKey<Level> levelKey, String subDirectory) {
        Path levelDataDir = server.m_129843_(LevelResource.f_78178_).getParent();
        if (Level.f_46428_.equals(levelKey)) {
            return levelDataDir.resolve(subDirectory);
        }
        if (Level.f_46429_.equals(levelKey)) {
            return levelDataDir.resolve("DIM-1").resolve(subDirectory);
        }
        if (Level.f_46430_.equals(levelKey)) {
            return levelDataDir.resolve("DIM1").resolve(subDirectory);
        }
        return levelDataDir.resolve("dimensions").resolve(levelKey.m_135782_().m_135827_()).resolve(levelKey.m_135782_().m_135815_()).resolve(subDirectory);
    }

    public static boolean isPlayerInDungeonDimension(ServerPlayer player) {
        return player.m_183503_().m_46472_().equals(DUNGEON_DIMENSION);
    }

    public static String posToString(BlockPos pos) {
        return String.format("%d %d %d", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    @NotNull
    public static Team getTeamForPlayerOrThrow(ServerPlayer player) throws CommandSyntaxException {
        Team team = FTBTeamsAPI.getPlayerTeam((ServerPlayer)player);
        if (team == null) {
            throw TeamArgument.TEAM_NOT_FOUND.create((Object)player.m_142049_());
        }
        return team;
    }
}

