/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbdungeons.dungeon;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import dev.ftb.mods.ftbdungeons.FTBDungeons;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonType;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class DungeonTypeManager {
    private static final DungeonTypeManager INSTANCE = new DungeonTypeManager();
    private final Map<ResourceLocation, DungeonType> TYPES = new ConcurrentHashMap<ResourceLocation, DungeonType>();
    private List<String> typeStrings = null;

    public static DungeonTypeManager getInstance() {
        return INSTANCE;
    }

    public Optional<DungeonType> getDungeonType(ResourceLocation typeId) {
        return Optional.ofNullable(this.TYPES.get(typeId));
    }

    public List<String> knownTypeStrings() {
        if (this.typeStrings == null) {
            this.typeStrings = this.TYPES.values().stream().sorted(Comparator.comparing(DungeonType::dungeonId)).map(type -> type.dungeonId().toString()).toList();
        }
        return this.typeStrings;
    }

    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

        public ReloadListener() {
            super(GSON, "ftb_dungeon_types");
        }

        protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
            Map<ResourceLocation, DungeonType> types = DungeonTypeManager.getInstance().TYPES;
            types.clear();
            object.forEach((id, json) -> DungeonType.fromJson(json).ifPresent(type -> types.put((ResourceLocation)id, (DungeonType)type)));
            DungeonTypeManager.getInstance().typeStrings = null;
            FTBDungeons.LOGGER.info("Loaded {} dungeon types from datapack", (Object)types.size());
        }
    }
}

