/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbdungeons.dungeon;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbdungeons.FTBDungeons;
import dev.ftb.mods.ftbdungeons.util.DungeonCodecs;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;

public record DungeonType(ResourceLocation dungeonId, String author, ResourceLocation templatePool, ResourceLocation target, int yPos, int maxGenerationDepth, Optional<BlockPos> generationOffset, Optional<BlockPos> playerSpawnOffset, Direction playerSpawnFacing, FrontAndTop jigsawOrientation, JigsawBlockEntity.JointType jointType) {
    public static final Codec<DungeonType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("dungeon_id").forGetter(DungeonType::dungeonId), (App)Codec.STRING.optionalFieldOf("author", (Object)"FTB Team").forGetter(DungeonType::author), (App)ResourceLocation.f_135803_.fieldOf("template_pool").forGetter(DungeonType::templatePool), (App)ResourceLocation.f_135803_.fieldOf("target").forGetter(DungeonType::target), (App)Codec.INT.optionalFieldOf("y_pos", (Object)64).forGetter(DungeonType::yPos), (App)Codec.intRange((int)1, (int)7).fieldOf("max_generation_depth").forGetter(DungeonType::maxGenerationDepth), (App)BlockPos.f_121852_.optionalFieldOf("generation_offset").forGetter(DungeonType::generationOffset), (App)BlockPos.f_121852_.optionalFieldOf("player_spawn_offset").forGetter(DungeonType::playerSpawnOffset), (App)Direction.f_175356_.optionalFieldOf("player_spawn_facing", (Object)Direction.NORTH).forGetter(DungeonType::playerSpawnFacing), (App)DungeonCodecs.FRONT_AND_TOP.optionalFieldOf("jigsaw_orientation", (Object)FrontAndTop.UP_NORTH).forGetter(DungeonType::jigsawOrientation), (App)DungeonCodecs.JOINT_TYPE.optionalFieldOf("joint_type", (Object)JigsawBlockEntity.JointType.ROLLABLE).forGetter(DungeonType::jointType)).apply((Applicative)instance, DungeonType::new));

    public static Optional<DungeonType> fromJson(JsonElement element) {
        return CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).resultOrPartial(error -> FTBDungeons.LOGGER.error("JSON parse failure: {}", error)).map(Pair::getFirst);
    }

    public static DungeonType dummyClientType(ResourceLocation id) {
        return new DungeonType(id, "Dummy", new ResourceLocation("nope"), new ResourceLocation("nope"), 64, 1, Optional.empty(), Optional.empty(), Direction.NORTH, FrontAndTop.UP_NORTH, JigsawBlockEntity.JointType.ROLLABLE);
    }
}

