/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbdungeons.dungeon;

import dev.ftb.mods.ftbdungeons.FTBDungeons;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonManager;
import dev.ftb.mods.ftbdungeons.util.DungeonUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public class DungeonPruner {
    private static final String PENDING_FILE = "prune-pending.snbt";

    public static int markInactiveForPruning(CommandSourceStack source) {
        DungeonManager manager = DungeonManager.getInstance();
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        tag.m_128365_("pending", (Tag)list);
        manager.getFinishedDungeons().forEach(dungeon -> {
            if (!dungeon.isPruned(source.m_81377_())) {
                list.add((Object)LongTag.m_128882_((long)dungeon.regionPos().toLong()));
            }
        });
        Path path = DungeonPruner.getPendingFile(source.m_81377_());
        if (SNBT.write((Path)path, (CompoundTag)tag)) {
            source.m_81354_((Component)new TranslatableComponent("ftbdungeons.messages.pruning", new Object[]{list.size()}), false);
            return 1;
        }
        source.m_81352_((Component)new TextComponent("can't save prune list to " + path).m_130940_(ChatFormatting.RED));
        return 0;
    }

    public static void pruneRegionFilesNow(MinecraftServer server) {
        SNBTCompoundTag tag;
        Path path = DungeonPruner.getPendingFile(server);
        if (Files.exists(path, new LinkOption[0]) && (tag = SNBT.read((Path)path)) != null && tag.m_128425_("pending", 9)) {
            ListTag list = tag.m_128437_("pending", 4);
            list.forEach(el -> {
                if (el instanceof LongTag) {
                    LongTag lt = (LongTag)el;
                    XZ xz = XZ.of((long)lt.m_7046_());
                    List.of("region", "poi", "entity").forEach(type -> {
                        Path mcaFile = DungeonUtils.levelKeyToPath(server, DungeonUtils.DUNGEON_DIMENSION, type).resolve(String.format("r.%d.%d.mca", xz.x, xz.z));
                        if (Files.exists(mcaFile, new LinkOption[0])) {
                            try {
                                Files.delete(mcaFile);
                                FTBDungeons.LOGGER.info("deleted inactive dungeon file: " + mcaFile);
                            }
                            catch (IOException e) {
                                FTBDungeons.LOGGER.error("can't delete {}: {}", (Object)mcaFile, (Object)e.getMessage());
                            }
                        }
                    });
                }
            });
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                FTBDungeons.LOGGER.error("can't delete {}: {}", (Object)path, (Object)e.getMessage());
            }
        }
    }

    private static Path getPendingFile(MinecraftServer server) {
        return server.m_129843_(LevelResource.f_78182_).resolve("ftbdungeons").resolve(PENDING_FILE);
    }
}

