/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbdungeons.dungeon;

import com.mojang.serialization.DynamicOps;
import dev.architectury.utils.GameInstance;
import dev.ftb.mods.ftbdungeons.DungeonException;
import dev.ftb.mods.ftbdungeons.FTBDungeons;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonInstance;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonType;
import dev.ftb.mods.ftbdungeons.util.DungeonUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;

public enum DungeonManager {
    INSTANCE_DONT_USE_DIRECTLY;

    private static final int EJECT_DELAY_SECS = 5;
    private DataStore dataStore = null;

    public static DungeonManager getInstance() {
        if (DungeonManager.INSTANCE_DONT_USE_DIRECTLY.dataStore == null) {
            DungeonManager.INSTANCE_DONT_USE_DIRECTLY.dataStore = DataStore.getInstance();
        }
        return INSTANCE_DONT_USE_DIRECTLY;
    }

    public DungeonInstance getOrCreateDungeon(ServerPlayer player, DungeonType type, BiConsumer<ServerPlayer, DungeonInstance> onCompleted) throws DungeonException {
        UUID teamID = FTBTeamsAPI.getPlayerTeamID((UUID)player.m_142081_());
        DungeonInstance existing = this.dataStore.activeByTeam.get(teamID);
        if (existing != null) {
            if (existing.type() == type) {
                onCompleted.accept(player, existing);
                return this.dataStore.activeByTeam.get(teamID);
            }
            throw new DungeonException("Dungeon of a different type already exists for your team! " + existing.type());
        }
        try {
            DungeonInstance instance = DungeonInstance.create(this, type, teamID);
            player.m_5661_((Component)new TextComponent("Preparing dungeon, stand by...").m_130940_(ChatFormatting.GOLD), true);
            instance.placeDungeonIntoWorld(player, DungeonUtils.dungeonDimension(player.f_8924_), onCompleted);
            ++this.dataStore.nextIdx;
            this.dataStore.active.put(instance.dungeonId(), instance);
            this.dataStore.activeByTeam.put(teamID, instance);
            this.setDirty();
            return instance;
        }
        catch (Exception e) {
            throw new DungeonException("Dungeon creation failure: " + e.getMessage());
        }
    }

    public XZ getNextRegionPos() {
        return DungeonUtils.spiralOut(this.dataStore.nextIdx);
    }

    public Collection<DungeonInstance> getActiveDungeons() {
        return Collections.unmodifiableCollection(this.dataStore.active.values());
    }

    public Collection<DungeonInstance> getFinishedDungeons() {
        return Collections.unmodifiableCollection(this.dataStore.inactive.values());
    }

    public Collection<DungeonInstance> getFinishedDungeons(Team team) {
        return this.dataStore.inactive.values().stream().filter(d -> d.teamId().equals(team.getId())).toList();
    }

    public Optional<DungeonInstance> getActiveDungeonForTeam(Team team) {
        return Optional.ofNullable(this.dataStore.activeByTeam.get(team.getId()));
    }

    public Optional<DungeonInstance> getActiveDungeon(UUID dungeonId) {
        return Optional.ofNullable(this.dataStore.active.get(dungeonId));
    }

    public Optional<DungeonInstance> getFinishedDungeon(UUID dungeonId) {
        return Optional.ofNullable(this.dataStore.inactive.get(dungeonId));
    }

    public void terminateDungeon(UUID teamId, boolean successful) throws DungeonException {
        DungeonInstance dungeon = this.dataStore.activeByTeam.remove(teamId);
        if (dungeon != null) {
            this.dataStore.active.remove(dungeon.dungeonId());
            this.dataStore.inactive.put(dungeon.dungeonId(), dungeon.finished(successful));
            this.setDirty();
            Team team = FTBTeamsAPI.getManager().getTeamByID(teamId);
            if (team != null) {
                for (ServerPlayer player : team.getOnlineMembers()) {
                    MutableComponent msg = successful ? new TranslatableComponent("ftbdungeons.messages.completed", new Object[]{dungeon.getDisplayName().m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GREEN) : new TranslatableComponent("ftbdungeons.messages.failed", new Object[]{dungeon.getDisplayName().m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.GOLD);
                    player.m_5661_((Component)msg, false);
                    if (!DungeonUtils.isPlayerInDungeonDimension(player)) continue;
                    this.dataStore.pendingEjections.put(player.m_142081_(), System.currentTimeMillis() + 5000L);
                }
            }
        } else {
            throw new DungeonException("no dungeon for team " + teamId);
        }
    }

    public void tick(MinecraftServer server) {
        if (server.m_129921_() % 20 == 0 && !this.dataStore.pendingEjections.isEmpty()) {
            long now = System.currentTimeMillis();
            HashSet toRemove = new HashSet();
            this.dataStore.pendingEjections.forEach((id, when) -> {
                ServerPlayer player = server.m_6846_().m_11259_(id);
                if (player != null) {
                    if (DungeonUtils.isPlayerInDungeonDimension(player)) {
                        if (when < now) {
                            this.removePlayerFromDungeon(player);
                            toRemove.add(id);
                        } else {
                            long secs = (when - now) / 1000L;
                            player.m_5661_((Component)new TranslatableComponent("ftbdungeons.messages.eject_in_seconds", new Object[]{secs}).m_130940_(ChatFormatting.YELLOW), true);
                        }
                    } else {
                        toRemove.add(id);
                    }
                }
            });
            if (!toRemove.isEmpty()) {
                this.setDirty();
            }
            toRemove.forEach(this.dataStore.pendingEjections::remove);
        }
    }

    public void removePlayerFromDungeon(ServerPlayer player) {
        GlobalPos gPos = this.getReturnPosition(player);
        Vec3 vec3 = Vec3.m_82512_((Vec3i)gPos.m_122646_());
        player.m_8999_(player.f_8924_.m_129880_(gPos.m_122640_()), vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), player.m_8962_(), -10.0f);
    }

    public GlobalPos getReturnPosition(ServerPlayer player) {
        if (this.dataStore.prevPlayerPos.containsKey(player.m_142081_())) {
            return this.dataStore.prevPlayerPos.get(player.m_142081_());
        }
        if (player.f_8924_.m_129880_(player.m_8963_()) != null) {
            return GlobalPos.m_122643_((ResourceKey)player.m_8963_(), (BlockPos)player.m_8961_());
        }
        ServerLevel overworld = Objects.requireNonNull(player.f_8924_.m_129880_(Level.f_46428_));
        return GlobalPos.m_122643_((ResourceKey)Level.f_46428_, (BlockPos)overworld.m_8900_());
    }

    public void setReturnPosition(ServerPlayer player) {
        this.dataStore.prevPlayerPos.put(player.m_142081_(), GlobalPos.m_122643_((ResourceKey)player.m_183503_().m_46472_(), (BlockPos)player.m_142538_()));
        this.setDirty();
    }

    public void setDirty() {
        this.dataStore.m_77762_();
    }

    public boolean setLocked(DungeonInstance dungeon, boolean locked) {
        if (locked != dungeon.locked()) {
            DungeonInstance newDungeon = dungeon.locked(locked);
            this.dataStore.active.put(newDungeon.dungeonId(), newDungeon);
            this.dataStore.activeByTeam.put(newDungeon.teamId(), newDungeon);
            this.setDirty();
            return true;
        }
        return false;
    }

    public static class DataStore
    extends SavedData {
        private static final String DATA_NAME = "FTB_Dungeons";
        private final Map<UUID, DungeonInstance> activeByTeam;
        private final Map<UUID, DungeonInstance> active;
        private final Map<UUID, DungeonInstance> inactive;
        private final Map<UUID, GlobalPos> prevPlayerPos;
        private final Map<UUID, Long> pendingEjections;
        private int nextIdx;

        public static DataStore getInstance() {
            MinecraftServer server = Objects.requireNonNull(GameInstance.getServer());
            ServerLevel overWorld = Objects.requireNonNull(server.m_129880_(Level.f_46428_));
            return (DataStore)overWorld.m_8895_().m_164861_(DataStore::new, DataStore::new, DATA_NAME);
        }

        private DataStore() {
            this.active = new HashMap<UUID, DungeonInstance>();
            this.activeByTeam = new HashMap<UUID, DungeonInstance>();
            this.inactive = new HashMap<UUID, DungeonInstance>();
            this.prevPlayerPos = new HashMap<UUID, GlobalPos>();
            this.pendingEjections = new HashMap<UUID, Long>();
            this.nextIdx = 0;
        }

        private DataStore(CompoundTag tag) {
            this.active = DataStore.readSection(tag, "active", UUID::fromString, DungeonInstance::fromNBT);
            this.inactive = DataStore.readSection(tag, "inactive", UUID::fromString, DungeonInstance::fromNBT);
            this.prevPlayerPos = DataStore.readSection(tag, "prev_pos", UUID::fromString, v -> (GlobalPos)GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, v).result().orElseThrow());
            this.pendingEjections = DataStore.readSection(tag, "pending_eject", UUID::fromString, v -> v.m_128454_("when"));
            this.nextIdx = tag.m_128451_("next_idx");
            this.activeByTeam = new HashMap<UUID, DungeonInstance>();
            this.active.forEach((id, val) -> this.activeByTeam.put(val.teamId(), (DungeonInstance)val));
        }

        public CompoundTag m_7176_(CompoundTag compoundTag) {
            CompoundTag tag = new CompoundTag();
            CompoundTag activeTag = (CompoundTag)Util.m_137469_((Object)new CompoundTag(), t -> this.active.forEach((id, instance) -> t.m_128365_(id.toString(), (Tag)instance.toNBT())));
            CompoundTag inactiveTag = (CompoundTag)Util.m_137469_((Object)new CompoundTag(), t -> this.inactive.forEach((id, instance) -> t.m_128365_(id.toString(), (Tag)instance.toNBT())));
            CompoundTag prevPos = (CompoundTag)Util.m_137469_((Object)new CompoundTag(), t -> this.prevPlayerPos.forEach((id, pos) -> t.m_128365_(id.toString(), (Tag)GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, pos).result().orElseThrow())));
            CompoundTag pendingEject = (CompoundTag)Util.m_137469_((Object)new CompoundTag(), t -> this.pendingEjections.forEach((id, when) -> t.m_128365_(id.toString(), (Tag)Util.m_137469_((Object)new CompoundTag(), t1 -> t1.m_128356_("when", when.longValue())))));
            tag.m_128365_("active", (Tag)activeTag);
            tag.m_128365_("inactive", (Tag)inactiveTag);
            tag.m_128365_("prev_pos", (Tag)prevPos);
            tag.m_128365_("pending_eject", (Tag)pendingEject);
            tag.m_128405_("next_idx", this.nextIdx);
            return tag;
        }

        private static <K, V> Map<K, V> readSection(CompoundTag tag, String name, Function<String, ? extends K> keyFunc, Function<CompoundTag, ? extends V> valFunc) {
            CompoundTag subTag = tag.m_128469_(name);
            HashMap<K, V> map = new HashMap<K, V>();
            for (String key : subTag.m_128431_()) {
                try {
                    map.put(keyFunc.apply(key), valFunc.apply(subTag.m_128469_(key)));
                }
                catch (Exception e) {
                    FTBDungeons.LOGGER.error("can't read saved dungeon data section {}, key {}: {}", (Object)name, (Object)key, (Object)e.getMessage());
                }
            }
            return map;
        }
    }
}

