/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbdungeons.dungeon;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbdungeons.DungeonException;
import dev.ftb.mods.ftbdungeons.FTBDungeons;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonManager;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonStatus;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonType;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonTypeManager;
import dev.ftb.mods.ftbdungeons.util.DungeonUtils;
import dev.ftb.mods.ftbdungeons.util.ProgressiveJigsawPlacer;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record DungeonInstance(DungeonType type, UUID dungeonId, UUID teamId, DungeonStatus status, XZ regionPos, long started, long finished, boolean locked, Map<UUID, PlayerStatus> players) {
    private final Map<UUID, PlayerStatus> players;
    private static final BlockPos REGION_CENTER = new BlockPos(256, 0, 256);
    private static final BlockPos UP_2 = new BlockPos(0, 2, 0);

    public static DungeonInstance create(DungeonManager manager, DungeonType type, UUID teamId) {
        return new DungeonInstance(type, UUID.randomUUID(), teamId, DungeonStatus.ACTIVE, manager.getNextRegionPos(), System.currentTimeMillis(), 0L, false, new HashMap<UUID, PlayerStatus>());
    }

    public Map<UUID, PlayerStatus> players() {
        return Collections.unmodifiableMap(this.players);
    }

    @Nullable
    public Team getTeam() {
        return FTBTeamsAPI.getManager().getTeamByID(this.teamId);
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", this.type.dungeonId().toString());
        tag.m_128359_("dungeonId", this.dungeonId.toString());
        tag.m_128359_("teamId", this.teamId.toString());
        tag.m_128359_("status", this.status.getName());
        tag.m_128356_("region", this.regionPos.toLong());
        tag.m_128356_("started", this.started);
        if (this.finished > 0L) {
            tag.m_128356_("finished", this.finished);
        }
        if (this.locked) {
            tag.m_128379_("locked", true);
        }
        tag.m_128365_("players", (Tag)Util.m_137469_((Object)new CompoundTag(), t -> this.players.forEach((id, state) -> t.m_128359_(id.toString(), state.name()))));
        return tag;
    }

    public static DungeonInstance fromNBT(CompoundTag tag) {
        ResourceLocation typeId = new ResourceLocation(tag.m_128461_("type"));
        DungeonType type = DungeonTypeManager.getInstance().getDungeonType(typeId).orElseThrow();
        UUID dungeonId = UUID.fromString(tag.m_128461_("dungeonId"));
        UUID teamId = UUID.fromString(tag.m_128461_("teamId"));
        DungeonStatus status = (DungeonStatus)((Object)DungeonStatus.NAME_MAP.getNullable(tag.m_128461_("status")));
        XZ regionPos = XZ.of((long)tag.m_128454_("region"));
        long started = tag.m_128454_("started");
        long finished = tag.m_128454_("finished");
        HashMap<UUID, PlayerStatus> players = new HashMap<UUID, PlayerStatus>();
        CompoundTag subTag = tag.m_128469_("players");
        for (String id : subTag.m_128431_()) {
            players.put(UUID.fromString(id), (PlayerStatus)((Object)PlayerStatus.NAME_MAP.get(subTag.m_128461_("state"))));
        }
        boolean locked = tag.m_128471_("locked");
        return new DungeonInstance(type, dungeonId, teamId, status, regionPos, started, finished, locked, players);
    }

    public BlockPos getGenerationPos() {
        return new BlockPos(this.regionPos.x << 9, this.type.yPos(), this.regionPos.z << 9).m_141952_((Vec3i)this.type.generationOffset().orElse(REGION_CENTER));
    }

    public BlockPos getPlayerEntryPos() {
        return this.getGenerationPos().m_141952_((Vec3i)this.type.playerSpawnOffset().orElse(UP_2));
    }

    public DungeonInstance finished(boolean successful) {
        return new DungeonInstance(this.type, this.dungeonId, this.teamId, DungeonStatus.finished(successful), this.regionPos, this.started, System.currentTimeMillis(), this.locked, this.players);
    }

    public DungeonInstance locked(boolean newLocked) {
        return new DungeonInstance(this.type, this.dungeonId, this.teamId, this.status, this.regionPos, this.started, this.finished, newLocked, this.players);
    }

    public void addNewPlayer(ServerPlayer player) {
        if (!this.players.containsKey(player.m_142081_()) && !DungeonUtils.isPlayerInDungeonDimension(player)) {
            DungeonManager.getInstance().setReturnPosition(player);
            this.players.put(player.m_142081_(), PlayerStatus.ACTIVE);
            this.teleportToDungeonEntrance(player);
        }
    }

    public void teleportToDungeonEntrance(ServerPlayer player) {
        Vec3 vec3 = Vec3.m_82512_((Vec3i)this.getPlayerEntryPos());
        player.m_8999_(DungeonUtils.dungeonDimension(player.f_8924_), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.type.playerSpawnFacing().m_122435_(), 0.0f);
    }

    public void playerLeftEarly(Player player) {
        if (this.players.containsKey(player.m_142081_())) {
            this.players.put(player.m_142081_(), PlayerStatus.BARRED);
            DungeonManager.getInstance().setDirty();
            Team team = this.getTeam();
            if (team != null) {
                team.getOnlineMembers().forEach(p -> p.m_5661_((Component)new TranslatableComponent("ftbdungeons.messages.player_left", new Object[]{player.m_5446_()}).m_130940_(ChatFormatting.YELLOW), false));
            }
        }
        if (this.players.values().stream().allMatch(s -> s == PlayerStatus.BARRED)) {
            try {
                DungeonManager.getInstance().terminateDungeon(this.teamId, false);
            }
            catch (DungeonException e) {
                FTBDungeons.LOGGER.error("failed to terminate dungeon {} due to player {} bailing: {}", (Object)this.teamId, (Object)player.m_36316_().getName(), (Object)e.getMessage());
            }
        }
    }

    public void placeDungeonIntoWorld(ServerPlayer player, ServerLevel level, BiConsumer<ServerPlayer, DungeonInstance> onCompleted) throws DungeonException {
        BlockPos origin = this.getGenerationPos();
        ChunkPos cp = new ChunkPos(origin);
        if (level.m_7726_().m_7587_(cp.f_45578_, cp.f_45579_, ChunkStatus.f_62326_, true) != null) {
            try {
                ProgressiveJigsawPlacer.placeJigsaw(this, player.m_20203_().m_81324_(), level, origin, onCompleted);
            }
            catch (CommandSyntaxException e) {
                throw new DungeonException(e.getMessage());
            }
        } else {
            throw new DungeonException("can't load chunk " + cp + " in " + level.m_46472_().m_135782_());
        }
    }

    public MutableComponent getDisplayName() {
        return new TranslatableComponent("ftbdungeons.dungeon_name." + this.type.dungeonId().toString().replace(':', '.'));
    }

    public boolean isPlayerBarred(ServerPlayer player) {
        return this.players.getOrDefault(player.m_142081_(), PlayerStatus.NOT_ENTERED) == PlayerStatus.BARRED;
    }

    public boolean isPruned(MinecraftServer server) {
        Path mcaFile = DungeonUtils.levelKeyToPath(server, DungeonUtils.DUNGEON_DIMENSION, "region").resolve(String.format("r.%d.%d.mca", this.regionPos.x, this.regionPos.z));
        return !mcaFile.toFile().exists();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dungeonId);
    }

    public static enum PlayerStatus {
        NOT_ENTERED("not_entered"),
        ACTIVE("active"),
        BARRED("barred");

        public static final NameMap<PlayerStatus> NAME_MAP;
        private final String name;

        private PlayerStatus(String name) {
            this.name = name;
        }

        static {
            NAME_MAP = NameMap.of((Object)((Object)NOT_ENTERED), (Object[])PlayerStatus.values()).id(v -> v.name).create();
        }
    }
}

