/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbdungeons.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.ftb.mods.ftbdungeons.DungeonException;
import dev.ftb.mods.ftbdungeons.commands.DungeonTypeArgument;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonInstance;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonManager;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonPruner;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonStatus;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonType;
import dev.ftb.mods.ftbdungeons.util.DungeonUtils;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;

public class FTBDungeonsCommands {
    private static final DynamicCommandExceptionType UNKNOWN_DUNGEON = new DynamicCommandExceptionType(o -> new TranslatableComponent("commands.ftbdungeons.command.error.unknown_dungeon", new Object[]{o}));
    private static final SimpleCommandExceptionType ALREADY_IN_DUNGEON = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.ftbdungeons.command.error.already_there"));
    private static final DynamicCommandExceptionType TEAM_HAS_DUNGEON = new DynamicCommandExceptionType(o -> new TranslatableComponent("commands.ftbdungeons.command.error.team_has_dungeon", new Object[]{o}));
    private static final SimpleCommandExceptionType PLAYER_BARRED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.ftbdungeons.command.error.player_barred"));
    private static final DynamicCommandExceptionType DUNGEON_LOCKED = new DynamicCommandExceptionType(o -> new TranslatableComponent("commands.ftbdungeons.command.error.dungeon_locked", new Object[]{o}));
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbdungeons").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"create").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"type", (ArgumentType)DungeonTypeArgument.dungeonType()).executes(ctx -> FTBDungeonsCommands.createDungeon((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"target"), (DungeonType)ctx.getArgument("type", DungeonType.class)))))).then(Commands.m_82129_((String)"type", (ArgumentType)DungeonTypeArgument.dungeonType()).executes(ctx -> FTBDungeonsCommands.createDungeon((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_(), (DungeonType)ctx.getArgument("type", DungeonType.class)))))).then(Commands.m_82127_((String)"join").executes(ctx -> FTBDungeonsCommands.joinDungeon(((CommandSourceStack)ctx.getSource()).m_81375_())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"visit").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"team").then(Commands.m_82129_((String)"team", (ArgumentType)TeamArgument.create()).executes(ctx -> FTBDungeonsCommands.visitDungeon(((CommandSourceStack)ctx.getSource()).m_81375_(), TeamArgument.get((CommandContext)ctx, (String)"team")))))).then(Commands.m_82127_((String)"id").then(Commands.m_82129_((String)"id", (ArgumentType)UuidArgument.m_113850_()).executes(ctx -> FTBDungeonsCommands.visitDungeon(((CommandSourceStack)ctx.getSource()).m_81375_(), UuidArgument.m_113853_((CommandContext)ctx, (String)"id"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"details").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"id", (ArgumentType)UuidArgument.m_113850_()).executes(ctx -> FTBDungeonsCommands.showDetails((CommandSourceStack)ctx.getSource(), UuidArgument.m_113853_((CommandContext)ctx, (String)"id")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"complete").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> FTBDungeonsCommands.finishDungeon((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"target"), true)))).executes(ctx -> FTBDungeonsCommands.finishDungeon((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_(), true)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"abandon").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> FTBDungeonsCommands.finishDungeon((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"target"), false)))).executes(ctx -> FTBDungeonsCommands.finishDungeon((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_(), false)))).then(Commands.m_82127_((String)"bail").executes(ctx -> FTBDungeonsCommands.bailFromDungeon(((CommandSourceStack)ctx.getSource()).m_81375_())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"lock").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"locked", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> FTBDungeonsCommands.lockDungeon(EntityArgument.m_91474_((CommandContext)ctx, (String)"target"), BoolArgumentType.getBool((CommandContext)ctx, (String)"locked"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"list").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"active").executes(ctx -> FTBDungeonsCommands.listActive((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"finished").executes(ctx -> FTBDungeonsCommands.listFinished((CommandSourceStack)ctx.getSource(), false))).then(Commands.m_82129_((String)"team", (ArgumentType)TeamArgument.create()).executes(ctx -> FTBDungeonsCommands.listFinished((CommandSourceStack)ctx.getSource(), TeamArgument.get((CommandContext)ctx, (String)"team"), false))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"pruned").executes(ctx -> FTBDungeonsCommands.listFinished((CommandSourceStack)ctx.getSource(), true))).then(Commands.m_82129_((String)"team", (ArgumentType)TeamArgument.create()).executes(ctx -> FTBDungeonsCommands.listFinished((CommandSourceStack)ctx.getSource(), TeamArgument.get((CommandContext)ctx, (String)"team"), true)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"prune-inactive").requires(source -> source.m_6761_(2))).executes(ctx -> DungeonPruner.markInactiveForPruning((CommandSourceStack)ctx.getSource()))));
    }

    private static int createDungeon(CommandSourceStack source, ServerPlayer player, DungeonType dungeonType) throws CommandSyntaxException {
        if (player.m_183503_().m_46472_().equals(DungeonUtils.DUNGEON_DIMENSION)) {
            throw ALREADY_IN_DUNGEON.create();
        }
        try {
            DungeonManager manager = DungeonManager.getInstance();
            Team team = DungeonUtils.getTeamForPlayerOrThrow(player);
            Optional<DungeonInstance> dungeon = manager.getActiveDungeonForTeam(team);
            if (dungeon.isPresent()) {
                throw TEAM_HAS_DUNGEON.create((Object)dungeon.get().getDisplayName());
            }
            manager.getOrCreateDungeon(player, dungeonType, FTBDungeonsCommands::onDungeonBuilt);
            return 1;
        }
        catch (DungeonException e) {
            source.m_81352_((Component)new TextComponent(e.getMessage()).m_130940_(ChatFormatting.RED));
            return 0;
        }
    }

    private static void onDungeonBuilt(ServerPlayer player, DungeonInstance dungeon) {
        dungeon.addNewPlayer(player);
        Team team = dungeon.getTeam();
        if (team instanceof PartyTeam) {
            PartyTeam partyTeam = (PartyTeam)team;
            for (ServerPlayer other : partyTeam.getOnlineMembers()) {
                if (other.m_142081_().equals(player.m_142081_()) || DungeonUtils.isPlayerInDungeonDimension(other)) continue;
                MutableComponent pName = player.m_5446_().m_6881_().m_130940_(ChatFormatting.YELLOW);
                other.m_5661_((Component)new TranslatableComponent("ftbdungeons.invited", new Object[]{pName, dungeon.getDisplayName().m_130940_(ChatFormatting.AQUA)}), false);
                other.m_5661_(DungeonUtils.makeJoinDungeonClicky(), false);
            }
        }
    }

    private static int listActive(CommandSourceStack source) {
        return FTBDungeonsCommands.listDungeons(source, DungeonManager.getInstance().getActiveDungeons());
    }

    private static int listFinished(CommandSourceStack source, boolean pruned) {
        return FTBDungeonsCommands.listDungeons(source, DungeonManager.getInstance().getFinishedDungeons().stream().filter(d -> d.isPruned(source.m_81377_()) == pruned).sorted(Comparator.comparingLong(DungeonInstance::started)).toList());
    }

    private static int listFinished(CommandSourceStack source, Team team, boolean pruned) {
        return FTBDungeonsCommands.listDungeons(source, DungeonManager.getInstance().getFinishedDungeons(team).stream().filter(d -> d.isPruned(source.m_81377_()) == pruned).sorted(Comparator.comparingLong(DungeonInstance::started)).toList());
    }

    private static int listDungeons(CommandSourceStack source, Collection<DungeonInstance> dungeons) {
        source.m_81354_((Component)new TranslatableComponent("ftbdungeons.messages.dungeons", new Object[]{dungeons.size()}).m_130940_(ChatFormatting.GREEN), false);
        for (DungeonInstance dungeon : dungeons) {
            FTBDungeonsCommands.showDungeonInfo(source, dungeon);
        }
        return 1;
    }

    private static int lockDungeon(ServerPlayer player, boolean locked) throws CommandSyntaxException {
        DungeonInstance dungeon;
        Team team = DungeonUtils.getTeamForPlayerOrThrow(player);
        DungeonManager manager = DungeonManager.getInstance();
        if (manager.setLocked(dungeon = manager.getActiveDungeonForTeam(team).orElseThrow(() -> UNKNOWN_DUNGEON.create((Object)team.getDisplayName())), locked)) {
            team.getOnlineMembers().forEach(member -> {
                if (locked) {
                    member.m_5661_((Component)new TranslatableComponent("ftbdungeons.messages.dungeon_locked", new Object[]{dungeon.getDisplayName().m_130940_(ChatFormatting.AQUA)}), false);
                } else {
                    member.m_5661_((Component)new TranslatableComponent("ftbdungeons.messages.dungeon_unlocked", new Object[]{dungeon.getDisplayName().m_130940_(ChatFormatting.AQUA)}), false);
                    if (!DungeonUtils.isPlayerInDungeonDimension(member)) {
                        member.m_5661_(DungeonUtils.makeJoinDungeonClicky(), false);
                    }
                }
            });
        }
        return 1;
    }

    private static void showDungeonInfo(CommandSourceStack source, DungeonInstance dungeon) {
        Component visit = DungeonUtils.makeCommandClicky("ftbdungeons.clicky.visit", ChatFormatting.GREEN, "/ftbdungeons visit id " + dungeon.dungeonId());
        Component details = DungeonUtils.makeCommandClicky("ftbdungeons.clicky.details", ChatFormatting.GREEN, "/ftbdungeons details " + dungeon.dungeonId());
        Team team = dungeon.getTeam();
        String started = DATE_FORMAT.format(new Date(dungeon.started()));
        MutableComponent name = team == null ? new TextComponent("???").m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("ftbteams.team_not_found", new Object[]{dungeon.teamId()})))) : team.getName().m_6881_();
        source.m_81354_((Component)name.m_130940_(ChatFormatting.YELLOW).m_130946_(" - ").m_7220_((Component)dungeon.getDisplayName().m_130940_(ChatFormatting.AQUA)).m_130946_(" - ").m_130946_(started), false);
        source.m_81354_((Component)new TextComponent("  ").m_7220_(visit).m_130946_(" ").m_7220_(details), false);
    }

    private static int showDetails(CommandSourceStack source, UUID id) throws CommandSyntaxException {
        DungeonManager manager = DungeonManager.getInstance();
        DungeonInstance dungeon = manager.getActiveDungeon(id).or(() -> manager.getFinishedDungeon(id)).orElseThrow(() -> UNKNOWN_DUNGEON.create((Object)id));
        Team team = dungeon.getTeam();
        source.m_81354_((Component)new TextComponent(Strings.repeat((char)'-', (int)40)).m_130940_(ChatFormatting.GREEN), false);
        FTBDungeonsCommands.addLine(source, "ftbdungeons.details.type", (Component)dungeon.getDisplayName());
        FTBDungeonsCommands.addLine(source, "ftbdungeons.details.team_name", team == null ? "(missing team)" : team.getStringID());
        FTBDungeonsCommands.addLine(source, "ftbdungeons.details.entry_pos", DungeonUtils.posToString(dungeon.getPlayerEntryPos()));
        FTBDungeonsCommands.addLine(source, "ftbdungeons.details.status", dungeon.status().toString());
        FTBDungeonsCommands.addLine(source, "ftbdungeons.details.started", DATE_FORMAT.format(new Date(dungeon.started())));
        if (dungeon.status() != DungeonStatus.ACTIVE) {
            FTBDungeonsCommands.addLine(source, "ftbdungeons.details.finished", DATE_FORMAT.format(new Date(dungeon.finished())));
        }
        return 1;
    }

    private static void addLine(CommandSourceStack source, String key, Component data) {
        source.m_81354_((Component)new TranslatableComponent(key, new Object[]{data.m_6881_().m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.YELLOW), false);
    }

    private static void addLine(CommandSourceStack source, String key, String data) {
        source.m_81354_((Component)new TranslatableComponent(key, new Object[]{new TextComponent(data).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.YELLOW), false);
    }

    private static int joinDungeon(ServerPlayer player) throws CommandSyntaxException {
        if (player.m_183503_().m_46472_().equals(DungeonUtils.DUNGEON_DIMENSION)) {
            throw ALREADY_IN_DUNGEON.create();
        }
        Team team = FTBTeamsAPI.getPlayerTeam((ServerPlayer)player);
        DungeonInstance dungeon = DungeonManager.getInstance().getActiveDungeonForTeam(team).orElseThrow(() -> UNKNOWN_DUNGEON.create((Object)team.getDisplayName()));
        if (dungeon.isPlayerBarred(player)) {
            throw PLAYER_BARRED.create();
        }
        if (dungeon.locked()) {
            throw DUNGEON_LOCKED.create((Object)dungeon.getDisplayName());
        }
        dungeon.addNewPlayer(player);
        return 1;
    }

    private static int visitDungeon(ServerPlayer player, Team team) throws CommandSyntaxException {
        DungeonInstance dungeon = DungeonManager.getInstance().getActiveDungeonForTeam(team).orElseThrow(() -> UNKNOWN_DUNGEON.create((Object)team.getDisplayName()));
        dungeon.teleportToDungeonEntrance(player);
        return 1;
    }

    private static int visitDungeon(ServerPlayer player, UUID id) throws CommandSyntaxException {
        DungeonManager manager = DungeonManager.getInstance();
        DungeonInstance dungeon = manager.getActiveDungeon(id).or(() -> manager.getFinishedDungeon(id)).orElseThrow(() -> UNKNOWN_DUNGEON.create((Object)id));
        dungeon.teleportToDungeonEntrance(player);
        return 1;
    }

    private static int finishDungeon(CommandSourceStack source, ServerPlayer player, boolean success) throws CommandSyntaxException {
        Team team = DungeonUtils.getTeamForPlayerOrThrow(player);
        try {
            DungeonManager.getInstance().terminateDungeon(team.getId(), success);
        }
        catch (DungeonException e) {
            throw UNKNOWN_DUNGEON.create((Object)team.getId());
        }
        return 1;
    }

    private static int bailFromDungeon(ServerPlayer player) {
        Team team = FTBTeamsAPI.getManager().getPlayerTeam(player);
        if (team != null && DungeonUtils.isPlayerInDungeonDimension(player)) {
            DungeonManager manager = DungeonManager.getInstance();
            manager.getActiveDungeonForTeam(team).ifPresent(dungeon -> manager.removePlayerFromDungeon(player));
            return 1;
        }
        return 0;
    }
}

