/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbdungeons.commands;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonType;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonTypeManager;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class DungeonTypeArgument
implements ArgumentType<DungeonType> {
    public static final DynamicCommandExceptionType UNKNOWN_TYPE = new DynamicCommandExceptionType(o -> new TranslatableComponent("commands.ftbdungeons.command.error.unknown_type", new Object[]{o}));
    private final Supplier<List<String>> knownTypes;
    private final boolean client;

    private DungeonTypeArgument() {
        this.knownTypes = () -> DungeonTypeManager.getInstance().knownTypeStrings();
        this.client = false;
    }

    private DungeonTypeArgument(List<String> typesFromServer) {
        this.knownTypes = () -> typesFromServer;
        this.client = true;
    }

    public static DungeonTypeArgument dungeonType() {
        return new DungeonTypeArgument();
    }

    public DungeonType parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocation.m_135818_((StringReader)reader);
        if (this.client) {
            if (this.knownTypes.get().contains(id.toString())) {
                return DungeonType.dummyClientType(id);
            }
            throw UNKNOWN_TYPE.create((Object)id);
        }
        return DungeonTypeManager.getInstance().getDungeonType(id).orElseThrow(() -> UNKNOWN_TYPE.create((Object)id));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_((Iterable)this.knownTypes.get(), (SuggestionsBuilder)builder);
    }

    public static class Serializer
    implements ArgumentSerializer<DungeonTypeArgument> {
        public void serializeToNetwork(DungeonTypeArgument argumentType, FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.m_178352_((Collection)argumentType.knownTypes.get(), FriendlyByteBuf::m_130070_);
        }

        public DungeonTypeArgument deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
            List types = friendlyByteBuf.m_178366_(buf -> buf.m_130136_(Short.MAX_VALUE));
            return new DungeonTypeArgument(types);
        }

        public void serializeToJson(DungeonTypeArgument argumentType, JsonObject jsonObject) {
            JsonArray a = new JsonArray();
            argumentType.knownTypes.get().forEach(arg_0 -> ((JsonArray)a).add(arg_0));
            jsonObject.add("types", (JsonElement)a);
        }
    }
}

