/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbdungeons;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.ftb.mods.ftbdungeons.commands.DungeonTypeArgument;
import dev.ftb.mods.ftbdungeons.commands.FTBDungeonsCommands;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonManager;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonPruner;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonStatus;
import dev.ftb.mods.ftbdungeons.dungeon.DungeonTypeManager;
import dev.ftb.mods.ftbdungeons.util.DungeonUtils;
import dev.ftb.mods.ftbdungeons.util.ProgressiveJigsawPlacer;
import dev.ftb.mods.ftbdungeons.worldgen.ModChunkGenerators;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.event.PlayerLeftPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FTBDungeons {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "ftbdungeons";

    public static void init() {
        ModChunkGenerators.init();
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)new DungeonTypeManager.ReloadListener());
        LifecycleEvent.SERVER_BEFORE_START.register(FTBDungeons::onServerBeforeStart);
        TickEvent.SERVER_POST.register(FTBDungeons::onServerTick);
        CommandRegistrationEvent.EVENT.register(FTBDungeons::onRegisterCommands);
        PlayerEvent.CHANGE_DIMENSION.register(FTBDungeons::onPlayerChangeDimension);
        PlayerEvent.PLAYER_CLONE.register(FTBDungeons::onPlayerClone);
        TeamEvent.PLAYER_LOGGED_IN.register(FTBDungeons::onPlayerLogin);
        TeamEvent.PLAYER_LEFT_PARTY.register(FTBDungeons::onPlayerLeaveTeam);
    }

    public static void setup() {
        ArgumentTypes.m_121601_((String)"ftbdungeons:dungeon_type", DungeonTypeArgument.class, (ArgumentSerializer)new DungeonTypeArgument.Serializer());
    }

    private static void onServerBeforeStart(MinecraftServer server) {
        DungeonPruner.pruneRegionFilesNow(server);
    }

    private static void onServerTick(MinecraftServer server) {
        if (server.m_129921_() % 2 == 0) {
            ProgressiveJigsawPlacer.tick();
        }
        if (server.m_129921_() % 20 == 0) {
            DungeonManager.getInstance().tick(server);
        }
    }

    private static void onRegisterCommands(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection selection) {
        FTBDungeonsCommands.register(dispatcher);
    }

    private static void onPlayerLogin(PlayerLoggedInAfterTeamEvent event) {
        ServerPlayer player = event.getPlayer();
        if (!DungeonUtils.isPlayerInDungeonDimension(player)) {
            DungeonManager.getInstance().getActiveDungeonForTeam(event.getTeam()).ifPresent(dungeon -> {
                if (!dungeon.locked()) {
                    player.m_5661_((Component)new TranslatableComponent("ftbdungeons.dungeon_running", new Object[]{dungeon.getDisplayName().m_130940_(ChatFormatting.YELLOW)}), false);
                    player.m_5661_(DungeonUtils.makeJoinDungeonClicky(), false);
                }
            });
        }
    }

    private static void onPlayerLeaveTeam(PlayerLeftPartyTeamEvent event) {
        DungeonManager manager;
        ServerPlayer player = event.getPlayer();
        if (player != null && DungeonUtils.isPlayerInDungeonDimension(player) && (manager = DungeonManager.getInstance()).getActiveDungeonForTeam(event.getTeam()).isPresent()) {
            manager.removePlayerFromDungeon(player);
        }
    }

    private static void onPlayerChangeDimension(ServerPlayer player, ResourceKey<Level> oldLevel, ResourceKey<Level> newLevel) {
        if (oldLevel.equals(DungeonUtils.DUNGEON_DIMENSION)) {
            FTBDungeons.playerLeavingDungeon(player);
        }
    }

    private static void onPlayerClone(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean wonGame) {
        if (!wonGame) {
            if (oldPlayer.m_6084_() && DungeonUtils.isPlayerInDungeonDimension(newPlayer)) {
                FTBDungeons.playerLeavingDungeon(newPlayer);
            } else if (newPlayer.m_6084_() && DungeonUtils.isPlayerInDungeonDimension(oldPlayer)) {
                FTBDungeons.playerLeavingDungeon(oldPlayer);
            }
        }
    }

    private static void playerLeavingDungeon(ServerPlayer player) {
        Team team = FTBTeamsAPI.getPlayerTeam((ServerPlayer)player);
        DungeonManager.getInstance().getActiveDungeonForTeam(team).ifPresent(dungeon -> {
            if (dungeon.status() == DungeonStatus.ACTIVE) {
                dungeon.playerLeftEarly((Player)player);
            }
        });
    }
}

