/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamislands.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbteamislands.FTBTeamIslands;
import dev.ftb.mods.ftbteamislands.islands.PrebuiltIslands;
import dev.ftb.mods.ftbteamislands.screens.IslandDirectoryScreen;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class IslandSelectScreen
extends Screen {
    private final List<PrebuiltIslands> previousScreenData;
    private final PrebuiltIslands selectedIslandDir;
    public Consumer<PrebuiltIslands.PrebuiltIsland> onSelect;
    private IslandList islandList;
    private EditBox searchBox;
    private Button createButton;

    public IslandSelectScreen(PrebuiltIslands selected, List<PrebuiltIslands> previousScreenData, Consumer<PrebuiltIslands.PrebuiltIsland> onSelect) {
        super(TextComponent.f_131282_);
        this.selectedIslandDir = selected;
        this.previousScreenData = previousScreenData;
        this.onSelect = onSelect;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.islandList = new IslandList(this.getMinecraft(), this.f_96543_, this.f_96544_, 80, this.f_96544_ - 40, this.selectedIslandDir);
        this.searchBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 80, 40, 160, 20, TextComponent.f_131282_);
        this.searchBox.m_94151_(this.islandList::searchList);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 130, this.f_96544_ - 30, 100, 20, (Component)new TranslatableComponent("screens.ftbteamislands.back"), btn -> Minecraft.m_91087_().m_91152_((Screen)new IslandDirectoryScreen(this.previousScreenData, this.onSelect))));
        this.createButton = new Button(this.f_96543_ / 2 - 20, this.f_96544_ - 30, 150, 20, (Component)new TranslatableComponent("screens.ftbteamislands.create"), btn -> {
            if (this.islandList.m_93511_() == null) {
                return;
            }
            this.onSelect.accept(((IslandList.Entry)this.islandList.m_93511_()).islandDir);
            if (this.getMinecraft().f_91073_ != null) {
                this.m_7379_();
            }
        });
        this.m_142416_((GuiEventListener)this.createButton);
        this.createButton.f_93623_ = false;
        this.m_7787_((GuiEventListener)this.searchBox);
        this.m_7787_((GuiEventListener)this.islandList);
        this.m_94718_((GuiEventListener)this.searchBox);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float partialTick) {
        this.islandList.m_6305_(matrices, mouseX, mouseY, partialTick);
        this.searchBox.m_6305_(matrices, mouseX, mouseY, partialTick);
        super.m_6305_(matrices, mouseX, mouseY, partialTick);
        String value = new TranslatableComponent("screens.ftbteamislands.select_island").getString();
        this.f_96547_.m_92750_(matrices, value, (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92895_(value) / 2.0f, 20.0f, 0xFFFFFF);
    }

    public class IslandList
    extends AbstractSelectionList<Entry> {
        private final PrebuiltIslands islands;

        public IslandList(Minecraft minecraft, int width, int height, int top, int bottom, PrebuiltIslands entries) {
            super(minecraft, width, height, top, bottom, 50);
            this.islands = entries;
            this.m_6702_().addAll(entries.getIslands().stream().map(x$0 -> new Entry((PrebuiltIslands.PrebuiltIsland)x$0)).collect(Collectors.toList()));
        }

        public int m_5759_() {
            return 340;
        }

        protected int m_5756_() {
            return this.f_93388_ / 2 + 170;
        }

        public void setSelected(@Nullable Entry entry) {
            IslandSelectScreen.this.createButton.f_93623_ = entry != null;
            super.m_6987_((AbstractSelectionList.Entry)entry);
        }

        public void searchList(String value) {
            this.m_6702_().clear();
            String lowerValue = value.toLowerCase();
            if (lowerValue.equals("")) {
                this.m_6702_().addAll(this.islands.getIslands().stream().map(x$0 -> new Entry((PrebuiltIslands.PrebuiltIsland)x$0)).collect(Collectors.toList()));
                return;
            }
            this.m_6702_().addAll(this.islands.getIslands().stream().filter(island -> island.getName().toLowerCase().contains(lowerValue) || island.getDesc().toLowerCase().contains(lowerValue)).map(x$0 -> new Entry((PrebuiltIslands.PrebuiltIsland)x$0)).collect(Collectors.toList()));
        }

        public void m_142291_(NarrationElementOutput arg) {
        }

        public class Entry
        extends AbstractSelectionList.Entry<Entry> {
            private final PrebuiltIslands.PrebuiltIsland islandDir;
            private long lastClickTime;

            public Entry(PrebuiltIslands.PrebuiltIsland island) {
                this.islandDir = island;
            }

            public boolean m_6375_(double x, double y, int partialTick) {
                IslandList.this.setSelected(this);
                if (Util.m_137550_() - this.lastClickTime < 250L) {
                    IslandSelectScreen.this.m_7379_();
                    IslandSelectScreen.this.onSelect.accept(this.islandDir);
                    return true;
                }
                this.lastClickTime = Util.m_137550_();
                return false;
            }

            public void m_6311_(PoseStack matrices, int entryId, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean bl, float partialTicks) {
                Font font = Minecraft.m_91087_().f_91062_;
                int startX = left + 80;
                font.m_92750_(matrices, this.islandDir.getName(), (float)startX, (float)(top + 10), 0xFFFFFF);
                font.m_92750_(matrices, this.islandDir.getDesc(), (float)startX, (float)(top + 26), 0xFFFFFF);
                try {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)this.islandDir.getImage());
                    GuiComponent.m_93133_((PoseStack)matrices, (int)(left + 7), (int)(top + 7), (float)0.0f, (float)0.0f, (int)56, (int)32, (int)56, (int)32);
                }
                catch (Exception ex) {
                    FTBTeamIslands.LOGGER.warn("{} not found in resources", (Object)this.islandDir.getImage());
                }
            }
        }
    }
}

