/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamislands.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbteamislands.ClientHandler;
import dev.ftb.mods.ftbteamislands.islands.PrebuiltIslands;
import dev.ftb.mods.ftbteamislands.screens.IslandSelectScreen;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class IslandDirectoryScreen
extends Screen {
    private final List<PrebuiltIslands> islands;
    public DirectoryList islandDirectoryList;
    private EditBox searchBox;
    private Button selectButton;
    private Consumer<PrebuiltIslands.PrebuiltIsland> onPrebuiltSelect;

    public IslandDirectoryScreen(List<PrebuiltIslands> islands, Consumer<PrebuiltIslands.PrebuiltIsland> onPrebuiltSelect) {
        super(TextComponent.f_131282_);
        this.islands = islands;
        this.onPrebuiltSelect = onPrebuiltSelect;
        ClientHandler.selectedIsland = null;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.islandDirectoryList = new DirectoryList(this.getMinecraft(), this.f_96543_, this.f_96544_, 80, this.f_96544_ - 35, this.islands);
        this.searchBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 80, 40, 160, 20, TextComponent.f_131282_);
        this.searchBox.m_94151_(value -> this.islandDirectoryList.searchList((String)value));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 130, this.f_96544_ - 30, 100, 20, (Component)new TranslatableComponent("screens.ftbteamislands.close"), btn -> this.m_7379_()));
        this.selectButton = new Button(this.f_96543_ / 2 - 20, this.f_96544_ - 30, 150, 20, (Component)new TranslatableComponent("screens.ftbteamislands.select"), btn -> {
            if (this.islandDirectoryList.m_93511_() == null) {
                return;
            }
            Minecraft.m_91087_().m_91152_((Screen)new IslandSelectScreen(((DirectoryList.DirectoryEntry)this.islandDirectoryList.m_93511_()).islandDir, this.islands, this.onPrebuiltSelect));
        });
        this.m_142416_((GuiEventListener)this.selectButton);
        this.m_7787_((GuiEventListener)this.searchBox);
        this.m_7787_((GuiEventListener)this.islandDirectoryList);
        this.m_94718_((GuiEventListener)this.searchBox);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float partialTicks) {
        this.islandDirectoryList.m_6305_(matrices, mouseX, mouseY, partialTicks);
        this.searchBox.m_6305_(matrices, mouseX, mouseY, partialTicks);
        super.m_6305_(matrices, mouseX, mouseY, partialTicks);
        String value = new TranslatableComponent("screens.ftbteamislands.select_island_category").getString();
        this.f_96547_.m_92750_(matrices, value, (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92895_(value) / 2.0f, 20.0f, 0xFFFFFF);
    }

    public void m_96624_() {
        this.searchBox.m_94120_();
    }

    public class DirectoryList
    extends AbstractSelectionList<DirectoryEntry> {
        private final List<PrebuiltIslands> islands;

        public DirectoryList(Minecraft minecraft, int width, int height, int top, int bottom, List<PrebuiltIslands> entries) {
            super(minecraft, width, height, top, bottom, 50);
            this.islands = entries;
            this.m_6702_().addAll(entries.stream().map(x$0 -> new DirectoryEntry((PrebuiltIslands)x$0)).collect(Collectors.toList()));
        }

        public int m_5759_() {
            return 340;
        }

        protected int m_5756_() {
            return this.f_93388_ / 2 + 170;
        }

        public void searchList(String value) {
            this.m_6702_().clear();
            String lowerValue = value.toLowerCase();
            if (lowerValue.equals("")) {
                this.m_6702_().addAll(this.islands.stream().map(x$0 -> new DirectoryEntry((PrebuiltIslands)x$0)).collect(Collectors.toList()));
                return;
            }
            this.m_6702_().addAll(this.islands.stream().filter(island -> island.getName().toLowerCase().contains(lowerValue) || island.getDesc().toLowerCase().contains(lowerValue)).map(x$0 -> new DirectoryEntry((PrebuiltIslands)x$0)).collect(Collectors.toList()));
        }

        public void setSelected(@Nullable DirectoryEntry entry) {
            IslandDirectoryScreen.this.selectButton.f_93623_ = entry != null;
            super.m_6987_((AbstractSelectionList.Entry)entry);
        }

        public void m_142291_(NarrationElementOutput arg) {
        }

        public class DirectoryEntry
        extends AbstractSelectionList.Entry<DirectoryEntry> {
            private final ResourceLocation fileIcon = new ResourceLocation("ftbteamislands", "textures/screens/foldericon.png");
            private final PrebuiltIslands islandDir;
            private long lastClickTime;

            public DirectoryEntry(PrebuiltIslands islandDir) {
                this.islandDir = islandDir;
            }

            public boolean m_6375_(double x, double y, int partialTick) {
                DirectoryList.this.setSelected(this);
                if (Util.m_137550_() - this.lastClickTime < 250L) {
                    Minecraft.m_91087_().m_91152_((Screen)new IslandSelectScreen(this.islandDir, IslandDirectoryScreen.this.islands, IslandDirectoryScreen.this.onPrebuiltSelect));
                    return true;
                }
                this.lastClickTime = Util.m_137550_();
                return false;
            }

            public void m_6311_(PoseStack matrices, int entryId, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean bl, float partialTicks) {
                Font font = Minecraft.m_91087_().f_91062_;
                int startX = left + 50;
                font.m_92750_(matrices, this.islandDir.getName(), (float)startX, (float)(top + 8), 0xFFFFFF);
                font.m_92763_(matrices, (Component)new TranslatableComponent("screens.ftbteamislands.by", new Object[]{this.islandDir.getAuthor()}), (float)(startX + font.m_92895_(this.islandDir.getName()) + 10), (float)(top + 8), 0xD3D3D3);
                font.m_92750_(matrices, this.islandDir.getDesc(), (float)startX, (float)(top + 24), 0xFFFFFF);
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.fileIcon);
                GuiComponent.m_93133_((PoseStack)matrices, (int)(left + 5), (int)(top + 8), (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                String islandCount = String.valueOf(this.islandDir.getIslands().size());
                font.m_92750_(matrices, islandCount, (float)(left + 22) - (float)font.m_92895_(islandCount) / 2.0f, (float)(top + 22), 0xFFFFFF);
            }
        }
    }
}

