/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamislands.network;

import dev.ftb.mods.ftbteamislands.ClientHandler;
import dev.ftb.mods.ftbteamislands.FTBTeamIslands;
import dev.ftb.mods.ftbteamislands.islands.PrebuiltIslands;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class OpenSelectionScreenPacket {
    private final List<PrebuiltIslands> islands;

    public OpenSelectionScreenPacket(List<PrebuiltIslands> islands) {
        this.islands = islands;
    }

    public void encode(FriendlyByteBuf buffer) {
        CompoundTag compound = new CompoundTag();
        ListTag list = new ListTag();
        this.islands.forEach(island -> list.add((Object)island.write()));
        compound.m_128365_("islands", (Tag)list);
        buffer.m_130079_(compound);
    }

    public static OpenSelectionScreenPacket decode(FriendlyByteBuf buffer) {
        CompoundTag compoundTag = buffer.m_130260_();
        if (compoundTag == null) {
            return new OpenSelectionScreenPacket(new ArrayList<PrebuiltIslands>());
        }
        ListTag islands = compoundTag.m_128437_("islands", 10);
        return new OpenSelectionScreenPacket(islands.stream().map(island -> PrebuiltIslands.read((CompoundTag)island)).collect(Collectors.toList()));
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                ClientHandler.openSelectionGui(this.islands);
                return;
            }
            FTBTeamIslands.LOGGER.error("Open gui packet sent to server!");
        });
        ctx.setPacketHandled(true);
    }
}

