/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamislands.network;

import dev.ftb.mods.ftbteamislands.FTBTeamIslands;
import dev.ftb.mods.ftbteamislands.islands.IslandSpawner;
import dev.ftb.mods.ftbteamislands.islands.IslandsManager;
import dev.ftb.mods.ftbteams.data.TeamManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class IslandSelectionPacket {
    String islandNbtFile;
    int yOffset;

    public IslandSelectionPacket(String islandNbtFile, int yOffset) {
        this.islandNbtFile = islandNbtFile;
        this.yOffset = yOffset;
    }

    public static IslandSelectionPacket decode(FriendlyByteBuf buffer) {
        return new IslandSelectionPacket(buffer.m_130136_(Short.MAX_VALUE), buffer.readInt());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.islandNbtFile);
        buffer.writeInt(this.yOffset);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                FTBTeamIslands.LOGGER.error("Selection packet fired on incorrect side");
                return;
            }
            ServerPlayer player = ctx.getSender();
            if (player == null || player.m_20194_() == null) {
                return;
            }
            player.m_5661_((Component)new TranslatableComponent("commands.ftbteamislands.response.island_creating"), false);
            IslandSpawner.spawnIsland(this.islandNbtFile, player.m_20194_().m_129880_(IslandsManager.getTargetIsland()), TeamManager.INSTANCE.getPlayerTeam(player), player, player.m_20194_(), this.yOffset);
            player.m_5661_((Component)new TranslatableComponent("commands.ftbteamislands.response.island_creating_finished"), false);
        });
        ctx.setPacketHandled(true);
    }
}

