/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamislands.islands;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class PrebuiltIslands {
    private final String name;
    private final String author;
    private final String desc;
    private final List<PrebuiltIsland> islands;

    public PrebuiltIslands(String name, String author, String desc, List<PrebuiltIsland> islands) {
        this.name = name;
        this.author = author;
        this.desc = desc;
        this.islands = islands;
    }

    public static PrebuiltIslands read(CompoundTag compound) {
        return new PrebuiltIslands(compound.m_128461_("name"), compound.m_128461_("author"), compound.m_128461_("desc"), compound.m_128437_("islands", 10).stream().map(tag -> PrebuiltIsland.read((CompoundTag)tag)).collect(Collectors.toList()));
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDesc() {
        return this.desc;
    }

    public List<PrebuiltIsland> getIslands() {
        return this.islands;
    }

    public CompoundTag write() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("name", this.name);
        compound.m_128359_("desc", this.desc);
        compound.m_128359_("author", this.author);
        ListTag list = new ListTag();
        this.islands.forEach(island -> list.add((Object)island.write()));
        compound.m_128365_("islands", (Tag)list);
        return compound;
    }

    public static class PrebuiltIsland {
        private final String name;
        private final String desc;
        private final String structureFileLocation;
        private final ResourceLocation image;
        private final int yOffset;

        public PrebuiltIsland(String name, String desc, String structureFileLocation, ResourceLocation image) {
            this(name, desc, structureFileLocation, image, 0);
        }

        public PrebuiltIsland(String name, String desc, String structureFileLocation, ResourceLocation image, int yOffset) {
            this.name = name;
            this.desc = desc;
            this.structureFileLocation = structureFileLocation;
            this.image = image;
            this.yOffset = yOffset;
        }

        public static PrebuiltIsland read(CompoundTag compound) {
            return new PrebuiltIsland(compound.m_128461_("name"), compound.m_128461_("desc"), compound.m_128461_("structure"), new ResourceLocation(compound.m_128461_("image")), compound.m_128451_("yOffset"));
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getStructureFileLocation() {
            return this.structureFileLocation;
        }

        public ResourceLocation getImage() {
            return this.image;
        }

        public CompoundTag write() {
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("name", this.name);
            compound.m_128359_("desc", this.desc);
            compound.m_128359_("structure", this.structureFileLocation);
            compound.m_128359_("image", this.image.toString());
            compound.m_128405_("yOffset", this.yOffset);
            return compound;
        }

        public int yOffset() {
            return this.yOffset;
        }

        public static class Deserializer
        implements JsonDeserializer<PrebuiltIsland> {
            public PrebuiltIsland deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject obj = json.getAsJsonObject();
                return new PrebuiltIsland(obj.get("name").getAsString(), obj.get("desc").getAsString(), obj.get("structure").getAsString(), new ResourceLocation(obj.get("image").getAsString()), obj.has("yOffset") ? obj.get("yOffset").getAsInt() : 0);
            }
        }
    }
}

