/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamislands.islands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import dev.ftb.mods.ftbteamislands.Config;
import dev.ftb.mods.ftbteamislands.FTBTeamIslands;
import dev.ftb.mods.ftbteamislands.islands.Island;
import dev.ftb.mods.ftbteamislands.islands.PrebuiltIslands;
import dev.ftb.mods.ftbteams.data.Team;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.fml.loading.FMLLoader;

public class IslandsManager {
    public static final LevelResource FOLDER_NAME = new LevelResource("ftbteamislands");
    public static final String PREBUILT_ISLANDS_PATH = "/config/ftbteamislands/";
    private static final String PREBUILT_ISLANDS_JSON = "/config/ftbteamislands//islands.json";
    private static final List<PrebuiltIslands> availableIslands = new ArrayList<PrebuiltIslands>();
    private static IslandsManager INSTANCE;
    public final MinecraftServer server;
    private final HashMap<UUID, Island> islands = new HashMap();
    private final HashMap<UUID, Island> deletedIslands = new HashMap();
    private int islandsEverCreated = 1;
    private boolean shouldSave;
    private Set<Path> islandsToDelete = new HashSet<Path>();
    @Nullable
    private Island lobby;

    private IslandsManager(MinecraftServer server) {
        this.server = server;
    }

    public static IslandsManager get() {
        return INSTANCE;
    }

    public static void setup(MinecraftServer server) {
        INSTANCE = new IslandsManager(server);
        INSTANCE.load();
    }

    public static ResourceKey<Level> getTargetIsland() {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation((String)Config.general.targetIslandLevel.get()));
    }

    public static boolean isEnabled(MinecraftServer server) {
        return server.m_6982_() ? (Boolean)Config.general.enableMultiplayer.get() : (Boolean)Config.general.enableSinglePlayer.get();
    }

    public static void createEmptyJson() {
        Path gamePath = FMLLoader.getGamePath();
        File file = new File(gamePath + PREBUILT_ISLANDS_PATH);
        if (file.exists()) {
            return;
        }
        try {
            file.mkdirs();
            File jsonFile = new File(file.getAbsolutePath() + "/islands.json");
            boolean didCreate = jsonFile.createNewFile();
            new File(gamePath + "/config/ftbteamislands/structures/").mkdir();
            if (didCreate) {
                FileWriter fileWriter = new FileWriter(jsonFile);
                fileWriter.write("[]");
                fileWriter.close();
            }
        }
        catch (IOException e) {
            FTBTeamIslands.LOGGER.error("Failed to auto generate islands json file [{}]", (Object)(gamePath + PREBUILT_ISLANDS_JSON));
        }
    }

    public static ListTag writeIslandsToTag(HashMap<UUID, Island> islands) {
        ListTag list = new ListTag();
        for (Map.Entry<UUID, Island> island : islands.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("key", island.getKey());
            tag.m_128365_("island", (Tag)island.getValue().write());
            list.add((Object)tag);
        }
        return list;
    }

    public static void findAndLoadPrebuilts() {
        FTBTeamIslands.LOGGER.info("Prebuilts: Searching for prebuilt islands in {}", (Object)PREBUILT_ISLANDS_JSON);
        Gson gson = new GsonBuilder().registerTypeAdapter(PrebuiltIslands.PrebuiltIsland.class, (Object)new PrebuiltIslands.PrebuiltIsland.Deserializer()).create();
        Type prebuiltIslandsType = new TypeToken<List<PrebuiltIslands>>(){}.getType();
        try {
            try {
                List islands = (List)gson.fromJson((Reader)new FileReader(FMLLoader.getGamePath() + PREBUILT_ISLANDS_JSON), prebuiltIslandsType);
                availableIslands.addAll(islands);
                FTBTeamIslands.LOGGER.info("Prebuilts: found {} islands in {}", (Object)availableIslands.stream().mapToInt(e -> e.getIslands().size()).count(), (Object)PREBUILT_ISLANDS_JSON);
            }
            catch (JsonIOException | JsonSyntaxException e2) {
                FTBTeamIslands.LOGGER.error("Prebuilts: Failed to read json data in {}", (Object)PREBUILT_ISLANDS_JSON);
            }
        }
        catch (FileNotFoundException e3) {
            FTBTeamIslands.LOGGER.info("Prebuilts: No islands found in {}", (Object)PREBUILT_ISLANDS_JSON);
        }
    }

    public static List<PrebuiltIslands> getAvailableIslands() {
        return availableIslands;
    }

    public void reloadPrebuilts() {
        availableIslands.clear();
        IslandsManager.findAndLoadPrebuilts();
    }

    public void registerIsland(Team team, Island island) {
        this.islands.put(team.getId(), island);
        ++this.islandsEverCreated;
        this.save();
    }

    public Optional<Island> getIsland(Team team) {
        Island island = this.islands.get(team.getId());
        return island == null ? Optional.empty() : Optional.of(island);
    }

    public void markUnclaimed(UUID teamId) {
        if (!this.islands.containsKey(teamId)) {
            return;
        }
        Island island = this.islands.get(teamId);
        island.creator = null;
        island.active = false;
        this.save();
    }

    public void removeIsland(UUID teamId) {
        Island island = this.islands.get(teamId);
        if (island == null) {
            return;
        }
        this.deletedIslands.put(teamId, island);
        this.islands.remove(teamId);
        this.save();
    }

    public Set<Map.Entry<UUID, Island>> getUnclaimedIslands() {
        return this.islands.entrySet().stream().filter(island -> !((Island)island.getValue()).isActive()).collect(Collectors.toSet());
    }

    public Optional<Island> getLobby() {
        return this.lobby != null ? Optional.of(this.lobby) : Optional.empty();
    }

    public void setLobby(@Nullable Island lobby) {
        this.lobby = lobby;
    }

    public HashMap<UUID, Island> getIslands() {
        return this.islands;
    }

    public void load() {
        CompoundTag compound = this.getSaveCompound();
        if (compound.m_128441_("islands")) {
            compound.m_128437_("islands", 10).forEach(island -> this.islands.put(((CompoundTag)island).m_128342_("key"), Island.read(((CompoundTag)island).m_128469_("island"))));
        }
        if (compound.m_128441_("deletedIslands")) {
            compound.m_128437_("deletedIslands", 10).forEach(island -> this.deletedIslands.put(((CompoundTag)island).m_128342_("key"), Island.read(((CompoundTag)island).m_128469_("island"))));
        }
        if (compound.m_128441_("lobby")) {
            this.lobby = Island.read(compound.m_128469_("lobby"));
        }
        this.islandsEverCreated = compound.m_128441_("islandsEverCreated") ? compound.m_128451_("islandsEverCreated") : 1;
    }

    public void save() {
        this.shouldSave = true;
    }

    public void saveNow() {
        Path directory = this.server.m_129843_(FOLDER_NAME);
        if (Files.notExists(directory, new LinkOption[0])) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.shouldSave) {
            try (OutputStream stream = Files.newOutputStream(directory.resolve("ftbteamislands.nbt"), new OpenOption[0]);){
                CompoundTag compound = new CompoundTag();
                if (this.lobby != null) {
                    compound.m_128365_("lobby", (Tag)this.lobby.write());
                }
                compound.m_128405_("islandsEverCreated", this.islandsEverCreated);
                compound.m_128365_("islands", (Tag)IslandsManager.writeIslandsToTag(this.islands));
                compound.m_128365_("deletedIslands", (Tag)IslandsManager.writeIslandsToTag(this.deletedIslands));
                NbtIo.m_128947_((CompoundTag)compound, (OutputStream)stream);
                this.shouldSave = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public CompoundTag getSaveCompound() {
        Path directory = this.server.m_129843_(FOLDER_NAME);
        if (Files.notExists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            return new CompoundTag();
        }
        Path dataFile = directory.resolve("ftbteamislands.nbt");
        if (Files.exists(dataFile, new LinkOption[0])) {
            CompoundTag compoundTag;
            block10: {
                InputStream stream = Files.newInputStream(dataFile, new OpenOption[0]);
                try {
                    compoundTag = Objects.requireNonNull(NbtIo.m_128939_((InputStream)stream));
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                stream.close();
            }
            return compoundTag;
        }
        return new CompoundTag();
    }

    public void addRegionToDelete(Path file) {
        this.islandsToDelete.add(file);
    }

    public Set<Path> getIslandsToDelete() {
        return this.islandsToDelete;
    }

    public int getIslandsEverCreated() {
        return this.islandsEverCreated;
    }
}

