/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamislands.islands;

import dev.ftb.mods.ftbteamislands.Config;
import dev.ftb.mods.ftbteamislands.FTBTeamIslands;
import dev.ftb.mods.ftbteamislands.FTBTeamIslandsEvents;
import dev.ftb.mods.ftbteamislands.intergration.FTBChunks;
import dev.ftb.mods.ftbteamislands.islands.Island;
import dev.ftb.mods.ftbteamislands.islands.IslandsManager;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.tuple.Pair;

public class IslandSpawner {
    public static void spawnLobby(ServerLevel level, ServerPlayer creator) {
        boolean result = new Worker(level, new ResourceLocation((String)Config.lobby.lobbyIslandFile.get())).setSpawnAt(new BlockPos(256, ((Integer)Config.islands.height.get()).intValue(), 256)).setGlobalSpawns(true).claimChunks(false).onCreation(island -> IslandsManager.get().setLobby((Island)island)).create(level.m_142572_(), creator);
        if (!result) {
            FTBTeamIslands.LOGGER.error("Failed to spawn island!");
        }
    }

    public static void spawnIsland(Worker worker, Team team, ServerPlayer player, MinecraftServer server, int yOffset) {
        if (player == null) {
            return;
        }
        int index = Math.max(1, IslandsManager.get().getIslandsEverCreated());
        int distanceInRegions = (Integer)Config.islands.distanceBetweenIslands.get();
        Pair<Integer, Integer> spiralLoc = IslandSpawner.calculateSpiral(index);
        boolean result = worker.setSpawnAt(new BlockPos(256 + (Integer)spiralLoc.getLeft() * distanceInRegions * 512, ((Integer)Config.islands.height.get()).intValue(), 256 + (Integer)spiralLoc.getRight() * distanceInRegions * 512)).setGlobalSpawns(IslandsManager.get().getLobby().isEmpty() && IslandsManager.get().getIslands().size() == 0).claimChunks(true).yOffset(yOffset).onCreation(island -> {
            IslandsManager.get().registerIsland(team, (Island)island);
            MinecraftForge.EVENT_BUS.post((Event)new FTBTeamIslandsEvents.IslandJoined(team, (Island)island, player, worker.structureLocation));
        }).create(server, player);
        if (!result) {
            FTBTeamIslands.LOGGER.error("Failed to spawn island!");
        }
    }

    public static void spawnIsland(String islandName, ServerLevel level, Team team, ServerPlayer player, MinecraftServer server, int yOffset) {
        try {
            FileInputStream file = new FileInputStream(server.m_6237_().getAbsolutePath() + "/config/ftbteamislands/structures/" + islandName);
            CompoundTag compoundTag = NbtIo.m_128939_((InputStream)file);
            if (compoundTag == null) {
                FTBTeamIslands.LOGGER.error("Failed to read `{}` island", (Object)islandName);
                return;
            }
            IslandSpawner.spawnIsland(new Worker(level, compoundTag, new ResourceLocation("ftbteamislands", "structures/" + islandName)), team, player, server, yOffset);
        }
        catch (IOException e) {
            FTBTeamIslands.LOGGER.error("Failed to find `{}` island in the prebuilt structures folder `{}/structures`", (Object)islandName, (Object)"/config/ftbteamislands/");
        }
    }

    public static void spawnIsland(ResourceLocation islandName, ServerLevel level, Team team, ServerPlayer player, MinecraftServer server, int yOffset) {
        IslandSpawner.spawnIsland(new Worker(level, islandName), team, player, server, yOffset);
    }

    private static Pair<Integer, Integer> calculateSpiral(int index) {
        if (index == 0) {
            return Pair.of((Object)0, (Object)0);
        }
        int x = 0;
        int z = 0;
        int dx = 0;
        int dz = 1;
        int segmentLength = 1;
        int segmentPassed = 0;
        for (int n = 0; n < index; ++n) {
            x += dx;
            z += dz;
            if (++segmentPassed != segmentLength) continue;
            segmentPassed = 0;
            int buffer = dz;
            dz = -dx;
            dx = buffer;
            if (dx != 0) continue;
            ++segmentLength;
        }
        return Pair.of((Object)x, (Object)z);
    }

    public static class Worker {
        private final StructureTemplate template;
        private final ServerLevel level;
        public final ResourceLocation structureLocation;
        private BlockPos spawnAt = BlockPos.f_121853_;
        private boolean setsGlobalSpawn = false;
        private boolean claimChunks = true;
        private Consumer<Island> onCreation;
        private int yOffset;

        public Worker(ServerLevel level, ResourceLocation nbtLocation) {
            this.onCreation = island -> {};
            this.yOffset = 0;
            this.template = (StructureTemplate)level.m_8875_().m_163774_(nbtLocation).get();
            this.structureLocation = nbtLocation;
            this.level = level;
        }

        public Worker(ServerLevel level, CompoundTag templateCompound, ResourceLocation structureLocation) {
            this.onCreation = island -> {};
            this.yOffset = 0;
            this.template = level.m_8875_().m_74339_(templateCompound);
            this.structureLocation = structureLocation;
            this.level = level;
        }

        public Worker setSpawnAt(BlockPos pos) {
            this.spawnAt = pos;
            return this;
        }

        public Worker setGlobalSpawns(boolean setGlobalSpawn) {
            this.setsGlobalSpawn = setGlobalSpawn;
            return this;
        }

        public Worker yOffset(int yOffset) {
            this.yOffset = yOffset;
            return this;
        }

        public Worker claimChunks(boolean claimChunks) {
            this.claimChunks = claimChunks;
            return this;
        }

        public Worker onCreation(Consumer<Island> consumer) {
            this.onCreation = consumer;
            return this;
        }

        public boolean create(MinecraftServer server, ServerPlayer player) {
            if (this.template == null) {
                return false;
            }
            BoundingBox boundingBox = this.template.m_74633_(new StructurePlaceSettings(), BlockPos.f_121853_);
            BoundingBox inWorldBoundingBox = this.template.m_74633_(new StructurePlaceSettings(), this.spawnAt.m_142082_(-boundingBox.m_162399_() / 2, this.yOffset, -boundingBox.m_162401_() / 2));
            BlockPos offset = this.spawnAt.m_142082_(-boundingBox.m_162399_() / 2, this.yOffset, -boundingBox.m_162401_() / 2);
            this.template.m_74536_((ServerLevelAccessor)this.level, offset, offset, new StructurePlaceSettings(), this.level.m_5822_(), 2);
            BlockPos playerSpawnPoint = this.spawnAt.m_6630_(2);
            Iterator iterator = BlockPos.m_121919_((BoundingBox)inWorldBoundingBox).iterator();
            while (iterator.hasNext()) {
                BlockPos next = (BlockPos)iterator.next();
                if (!(this.level.m_8055_(next).m_60734_() instanceof StructureBlock)) continue;
                BlockEntity blockEntity = this.level.m_7702_(next);
                if (blockEntity instanceof StructureBlockEntity) {
                    CompoundTag tag = blockEntity.m_187480_();
                    if (!tag.m_128461_("metadata").startsWith("SPAWN_POINT")) continue;
                    playerSpawnPoint = next.m_122032_();
                    this.level.m_7471_(next, false);
                    if (this.level.m_8055_(next.m_7495_()).m_60734_() != Blocks.f_50493_) continue;
                    this.level.m_7731_(next.m_7495_(), Blocks.f_50440_.m_49966_(), 2);
                    continue;
                }
                this.level.m_7471_(next, false);
            }
            Island island = new Island(new ChunkPos(this.spawnAt), playerSpawnPoint, null, true, true);
            MinecraftForge.EVENT_BUS.post((Event)new FTBTeamIslandsEvents.IslandCreated(TeamManager.INSTANCE.getPlayerTeam(player), island, this.structureLocation));
            island.teleportPlayerTo(player, server);
            MinecraftForge.EVENT_BUS.post((Event)new FTBTeamIslandsEvents.FirstTeleportTo(TeamManager.INSTANCE.getPlayerTeam(player), island, player, this.structureLocation));
            if (this.setsGlobalSpawn) {
                this.level.m_8733_(island.getSpawnPos(), 90.0f);
            }
            if (ModList.get().isLoaded("ftbchunks") && this.claimChunks && (Integer)Config.islands.autoClaimChunkRadius.get() != -1) {
                FTBChunks.claimChunks(player, (Level)player.m_183503_(), island.pos);
            }
            this.onCreation.accept(island);
            return true;
        }
    }
}

