/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamislands.islands;

import dev.ftb.mods.ftbteamislands.islands.IslandsManager;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;

public class Island {
    public ChunkPos pos;
    public BlockPos spawnPos;
    public UUID templateId = UUID.randomUUID();
    @Nullable
    public UUID creator;
    public boolean spawned;
    public boolean active;

    public Island(ChunkPos pos, BlockPos spawnPos, @Nullable UUID creator, boolean spawned, boolean active) {
        this.pos = pos;
        this.spawnPos = spawnPos;
        this.creator = creator;
        this.spawned = spawned;
        this.active = active;
    }

    public static Island read(CompoundTag compound) {
        Island island = new Island(new ChunkPos(compound.m_128454_("chunkPos")), NbtUtils.m_129239_((CompoundTag)compound.m_128469_("spawnPos")), compound.m_128441_("creator") ? compound.m_128342_("creator") : null, compound.m_128471_("spawned"), compound.m_128471_("active"));
        island.templateId = compound.m_128342_("templateId");
        return island;
    }

    public BlockPos getSpawnPos() {
        return this.spawnPos;
    }

    @Nullable
    public UUID getCreator() {
        return this.creator;
    }

    public boolean isSpawned() {
        return this.spawned;
    }

    public boolean isActive() {
        return this.active;
    }

    public void teleportPlayerTo(ServerPlayer player, MinecraftServer server) {
        ServerLevel level = server.m_129880_(IslandsManager.getTargetIsland());
        int lvl = player.f_36078_;
        Vec3 spawnPos = Vec3.m_82539_((Vec3i)new Vec3i(this.getSpawnPos().m_123341_(), this.getSpawnPos().m_123342_(), this.getSpawnPos().m_123343_()));
        player.m_8999_(level, spawnPos.f_82479_ + 0.5, spawnPos.f_82480_ + 0.1, spawnPos.f_82481_ + 0.5, player.m_146908_(), player.m_146909_());
        player.m_9174_(lvl);
    }

    public CompoundTag write() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("spawnPos", (Tag)NbtUtils.m_129224_((BlockPos)this.spawnPos));
        compound.m_128356_("chunkPos", this.pos.m_45588_());
        compound.m_128362_("templateId", this.templateId);
        if (this.creator != null) {
            compound.m_128362_("creator", this.creator);
        }
        compound.m_128379_("spawned", this.spawned);
        compound.m_128379_("active", this.active);
        return compound;
    }
}

