/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamislands.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbteamislands.islands.Island;
import dev.ftb.mods.ftbteamislands.islands.IslandsManager;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class ListIslandsCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"list").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).executes(ListIslandsCommand::execute);
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        HashMap<UUID, Island> islands = IslandsManager.get().getIslands();
        Set<UUID> unusedIslands = islands.keySet().stream().filter(e -> TeamManager.INSTANCE.getTeamByID(e) == null).collect(Collectors.toSet());
        unusedIslands.forEach(IslandsManager.get()::markUnclaimed);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("commands.ftbteamislands.response.islands_header"), false);
        for (Map.Entry<UUID, Island> entry : islands.entrySet()) {
            if (unusedIslands.contains(entry.getKey())) continue;
            Island island = entry.getValue();
            Team team = TeamManager.INSTANCE.getTeamByID(entry.getKey());
            if (!island.active || team == null) continue;
            MutableComponent text = new TranslatableComponent("commands.ftbteamislands.response.islands").m_7220_((Component)new TextComponent(team.getDisplayName()).m_130940_(ChatFormatting.LIGHT_PURPLE)).m_7220_((Component)new TranslatableComponent("commands.ftbteamislands.response.found_at", new Object[]{island.spawnPos.m_123341_() + ", " + island.spawnPos.m_123342_() + ", " + island.spawnPos.m_123343_()}));
            text.m_6270_(text.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/%s islands %s", "ftbteamislands", team.getStringID()))));
            ((CommandSourceStack)context.getSource()).m_81354_((Component)text, false);
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("commands.ftbteamislands.response.islands_header_inactive"), false);
        for (Island island : islands.values()) {
            if (island.active) continue;
            BlockPos spawnPos = island.getSpawnPos();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("commands.ftbteamislands.response.inactive_island", new Object[]{String.format("x: %d, y: %d, z: %d", spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_())}), false);
        }
        return 0;
    }
}

