/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamislands.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.ftb.mods.ftbteamislands.Config;
import dev.ftb.mods.ftbteamislands.commands.CommandsHelper;
import dev.ftb.mods.ftbteamislands.islands.Island;
import dev.ftb.mods.ftbteamislands.islands.IslandsManager;
import dev.ftb.mods.ftbteams.data.TeamManager;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;

public class HomeCommand {
    private static final SimpleCommandExceptionType NO_ISLAND_ERROR = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.ftbteamislands.error.no_island"));
    private static final SimpleCommandExceptionType DISABLED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.ftbteamislands.error.my_island_disabled"));

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"home").executes(HomeCommand::execute);
    }

    public static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandsHelper.exceptionIfDisabled(context);
        if (!((Boolean)Config.general.enableMyIslandCommand.get()).booleanValue()) {
            throw DISABLED.create();
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Optional<Island> island = IslandsManager.get().getIsland(TeamManager.INSTANCE.getPlayerTeam(player));
        if (!island.isPresent()) {
            throw NO_ISLAND_ERROR.create();
        }
        island.get().teleportPlayerTo(player, ((CommandSourceStack)context.getSource()).m_81377_());
        return 0;
    }
}

