/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamislands.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbteamislands.Config;
import dev.ftb.mods.ftbteamislands.commands.CommandsHelper;
import dev.ftb.mods.ftbteamislands.islands.Island;
import dev.ftb.mods.ftbteamislands.islands.IslandsManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.storage.LevelResource;

public class DeleteUnusedIslandsCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"delete").requires(commandSource -> commandSource.m_6761_(2))).executes(DeleteUnusedIslandsCommand::execute);
    }

    private static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandsHelper.exceptionIfDisabled(context);
        Set<Map.Entry<UUID, Island>> unclaimedIslands = IslandsManager.get().getUnclaimedIslands();
        int islandsToDelete = unclaimedIslands.size();
        int islandsDeleted = 0;
        int regionRadius = (Integer)Config.islands.distanceBetweenIslands.get() / 2;
        for (Map.Entry<UUID, Island> map : unclaimedIslands) {
            Island island = map.getValue();
            int posX = island.pos.f_45578_ >> 5;
            int posZ = island.pos.f_45579_ >> 5;
            boolean regionDeleted = false;
            for (int x = posX - regionRadius; x <= posX + regionRadius; ++x) {
                for (int z = posZ - regionRadius; z <= posZ + regionRadius; ++z) {
                    Path regionPath = ((CommandSourceStack)context.getSource()).m_81377_().m_129843_(LevelResource.f_78182_).resolve(String.format("region/r.%d.%d.mca", x, z));
                    if (!regionDeleted && Files.exists(regionPath, new LinkOption[0])) {
                        regionDeleted = true;
                        ++islandsDeleted;
                    }
                    IslandsManager.get().addRegionToDelete(regionPath);
                }
            }
            if (!regionDeleted) continue;
            IslandsManager.get().removeIsland(map.getKey());
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("commands.ftbteamislands.success.islands_deleted", new Object[]{islandsDeleted, islandsToDelete, islandsToDelete - islandsDeleted}), false);
        return 0;
    }
}

