/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamislands.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.ftb.mods.ftbteamislands.Config;
import dev.ftb.mods.ftbteamislands.commands.CommandsHelper;
import dev.ftb.mods.ftbteamislands.islands.IslandSpawner;
import dev.ftb.mods.ftbteamislands.islands.IslandsManager;
import dev.ftb.mods.ftbteamislands.network.NetworkManager;
import dev.ftb.mods.ftbteamislands.network.OpenSelectionScreenPacket;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.data.TeamType;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.apache.commons.lang3.tuple.Pair;

public class CreateIslandCommand {
    static final HashMap<UUID, Instant> playersTimeout = new HashMap();
    private static final SimpleCommandExceptionType ALREADY_OWN_ISLAND = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.ftbteamislands.error.already_have_island"));
    private static final SimpleCommandExceptionType TO_QUICK = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.ftbteamislands.error.to_quick"));
    private static final SimpleCommandExceptionType IN_PARTY = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.ftbteamislands.error.in_party"));

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"create").requires(CreateIslandCommand::notHasIsland)).executes(CreateIslandCommand::execute);
    }

    private static boolean notHasIsland(CommandSourceStack commandSourceStack) {
        ServerPlayer player;
        try {
            player = commandSourceStack.m_81375_();
        }
        catch (CommandSyntaxException e) {
            return false;
        }
        Team playerTeam = TeamManager.INSTANCE.getPlayerTeam(player.m_142081_());
        if (playerTeam == null) {
            return true;
        }
        return !IslandsManager.get().getIsland(playerTeam).isPresent();
    }

    private static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandsHelper.exceptionIfDisabled(context);
        IslandsManager manager = IslandsManager.get();
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Team playerTeam = TeamManager.INSTANCE.getPlayerTeam(player);
        if (playerTeam.getType() != TeamType.PARTY) {
            Pair party = TeamManager.INSTANCE.createParty(player, "");
            playerTeam = (Team)party.getValue();
            if (TeamManager.INSTANCE.getPlayerTeam(player).getType() != TeamType.PARTY) {
                throw IN_PARTY.create();
            }
        }
        if (manager.getIsland(playerTeam).isPresent()) {
            throw ALREADY_OWN_ISLAND.create();
        }
        CreateIslandCommand.spawnIslandWithRateLimit(player, ((CommandSourceStack)context.getSource()).m_81377_(), playerTeam);
        return 0;
    }

    public static void spawnIslandWithRateLimit(ServerPlayer player, MinecraftServer server, Team team) throws CommandSyntaxException {
        if (((Boolean)Config.general.creationTimeout.get()).booleanValue()) {
            Instant instant = playersTimeout.get(player.m_142081_());
            if (instant != null && !instant.plus(5L, ChronoUnit.MINUTES).isBefore(Instant.now()) && !player.m_20310_(2)) {
                throw TO_QUICK.create();
            }
            playersTimeout.put(player.m_142081_(), Instant.now());
        }
        if (IslandsManager.getAvailableIslands().size() > 0) {
            NetworkManager.sendTo(new OpenSelectionScreenPacket(IslandsManager.getAvailableIslands()), player);
            return;
        }
        IslandSpawner.spawnIsland(new ResourceLocation((String)Config.islands.defaultIslandResource.get()), server.m_129880_(IslandsManager.getTargetIsland()), team, player, server, (int)((Integer)Config.islands.defaultIslandResourceYOffset.get()));
    }
}

