/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamislands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.ftb.mods.ftbteamislands.Config;
import dev.ftb.mods.ftbteamislands.Events;
import dev.ftb.mods.ftbteamislands.commands.ChangeIslandSpawnPoint;
import dev.ftb.mods.ftbteamislands.commands.CreateIslandCommand;
import dev.ftb.mods.ftbteamislands.commands.DeleteUnusedIslandsCommand;
import dev.ftb.mods.ftbteamislands.commands.HomeCommand;
import dev.ftb.mods.ftbteamislands.commands.JumpToIslandCommand;
import dev.ftb.mods.ftbteamislands.commands.ListIslandsCommand;
import dev.ftb.mods.ftbteamislands.commands.LobbyCommand;
import dev.ftb.mods.ftbteamislands.commands.ReloadIslandsJsonCommand;
import dev.ftb.mods.ftbteamislands.islands.IslandsManager;
import dev.ftb.mods.ftbteamislands.network.NetworkManager;
import dev.ftb.mods.ftbteams.event.PlayerChangedTeamEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import java.io.IOException;
import java.nio.file.Files;
import net.minecraft.commands.Commands;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ftbteamislands")
public class FTBTeamIslands {
    public static final String MOD_ID = "ftbteamislands";
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Team Islands");

    public FTBTeamIslands() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        TeamEvent.DELETED.register(Events::onTeamDeleted);
        TeamEvent.CREATED.register(Events::onTeamCreated);
        PlayerChangedTeamEvent.PLAYER_CHANGED.register(Events::onChangedTeamEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        IslandsManager.createEmptyJson();
        NetworkManager.register();
        IslandsManager.findAndLoadPrebuilts();
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)MOD_ID).then(JumpToIslandCommand.register())).then(ListIslandsCommand.register())).then(LobbyCommand.register())).then(HomeCommand.register())).then(DeleteUnusedIslandsCommand.register())).then(CreateIslandCommand.register())).then(ReloadIslandsJsonCommand.register())).then(ChangeIslandSpawnPoint.register()));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"myisland").executes(HomeCommand::execute));
    }

    @SubscribeEvent
    public void onServerAboutToStart(ServerAboutToStartEvent event) {
        IslandsManager.setup(event.getServer());
    }

    @SubscribeEvent
    public void onServerShutdown(ServerStoppedEvent event) {
        IslandsManager.get().getIslandsToDelete().forEach(island -> {
            try {
                Files.deleteIfExists(island);
                LOGGER.error("Deleted {}", (Object)island.toString());
            }
            catch (IOException e) {
                LOGGER.error("Failed to delete {}", (Object)island.toString());
            }
        });
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        IslandsManager.get().saveNow();
    }
}

