/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamislands;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbteamislands.ClientHandler;
import dev.ftb.mods.ftbteamislands.Config;
import dev.ftb.mods.ftbteamislands.FTBTeamIslands;
import dev.ftb.mods.ftbteamislands.FTBTeamIslandsEvents;
import dev.ftb.mods.ftbteamislands.islands.Island;
import dev.ftb.mods.ftbteamislands.islands.IslandSpawner;
import dev.ftb.mods.ftbteamislands.islands.IslandsManager;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.event.PlayerChangedTeamEvent;
import dev.ftb.mods.ftbteams.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="ftbteamislands")
public class Events {
    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerTeam internalPlayerTeam = TeamManager.INSTANCE.getInternalPlayerTeam(event.getPlayer().m_142081_());
        if (internalPlayerTeam == null) {
            return;
        }
        boolean removeInventory = internalPlayerTeam.getExtraData().m_128471_("removeInventory");
        if (removeInventory) {
            event.getPlayer().m_150109_().m_6211_();
            internalPlayerTeam.getExtraData().m_128379_("removeInventory", false);
            internalPlayerTeam.save();
        }
    }

    public static void onTeamCreated(TeamCreatedEvent event) {
        Team team = event.getTeam();
        MinecraftServer server = team.manager.getServer();
        if (!IslandsManager.isEnabled(server)) {
            return;
        }
        ServerLevel level = team.manager.getServer().m_129880_(IslandsManager.getTargetIsland());
        IslandsManager islandsManager = IslandsManager.get();
        if (islandsManager == null || level == null) {
            return;
        }
        if (!islandsManager.getLobby().isPresent() && (server.m_6982_() || IslandsManager.getAvailableIslands().size() > 0 && ClientHandler.selectedIsland == null && IslandsManager.get().getIslandsEverCreated() == 1)) {
            IslandSpawner.spawnLobby(level, event.getCreator());
        }
        if (!server.m_6982_() && IslandsManager.get().getIslandsEverCreated() == 1 && team.getType() == TeamType.PLAYER) {
            try {
                Pair partyTeam = TeamManager.INSTANCE.createParty(event.getCreator(), "");
                if (ClientHandler.selectedIsland != null) {
                    IslandSpawner.spawnIsland(ClientHandler.selectedIsland.getStructureFileLocation(), server.m_129880_(IslandsManager.getTargetIsland()), (Team)partyTeam.getValue(), event.getCreator(), server, ClientHandler.selectedIsland.yOffset());
                    ClientHandler.selectedIsland = null;
                } else if (IslandsManager.getAvailableIslands().size() == 0) {
                    IslandSpawner.spawnIsland(new ResourceLocation((String)Config.islands.defaultIslandResource.get()), server.m_129880_(IslandsManager.getTargetIsland()), (Team)partyTeam.getValue(), event.getCreator(), server, (int)((Integer)Config.islands.defaultIslandResourceYOffset.get()));
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }

    public static void onChangedTeamEvent(PlayerChangedTeamEvent event) {
        Team team = event.getTeam();
        MinecraftServer server = team.manager.getServer();
        if (!IslandsManager.isEnabled(server)) {
            return;
        }
        Optional previousTeam = event.getPreviousTeam();
        ServerPlayer player = event.getPlayer();
        if (!previousTeam.isPresent() || player == null) {
            if (player == null) {
                PlayerTeam internalPlayerTeam = TeamManager.INSTANCE.getInternalPlayerTeam(event.getPlayerId());
                internalPlayerTeam.getExtraData().m_128379_("removeInventory", true);
                internalPlayerTeam.save();
            }
            return;
        }
        if (((Boolean)Config.general.clearInvWhenTeamLeft.get()).booleanValue()) {
            player.m_150109_().m_6211_();
        }
        if (((Team)previousTeam.get()).getType() == TeamType.PARTY && event.getTeam().getType() == TeamType.PLAYER) {
            IslandsManager.get().getLobby().ifPresent(e -> e.teleportPlayerTo(player, server));
        }
    }

    public static void onTeamDeleted(TeamEvent event) {
        Team team = event.getTeam();
        if (!IslandsManager.isEnabled(team.manager.getServer())) {
            return;
        }
        IslandsManager.get().getIsland(team).ifPresent(island -> MinecraftForge.EVENT_BUS.post((Event)new FTBTeamIslandsEvents.IslandMarkForDeletion(team, (Island)island)));
        IslandsManager.get().markUnclaimed(team.getId());
    }

    @SubscribeEvent
    public static void onPlayerDeath(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getPlayer().m_20194_() == null || !IslandsManager.isEnabled(event.getPlayer().m_20194_())) {
            return;
        }
        Team playerTeam = TeamManager.INSTANCE.getPlayerTeam(event.getPlayer().m_142081_());
        if (playerTeam == null) {
            return;
        }
        IslandsManager islandsManager = IslandsManager.get();
        if (((ServerPlayer)event.getPlayer()).m_8961_() != null) {
            return;
        }
        Island island = islandsManager.getIsland(playerTeam).orElse(islandsManager.getLobby().orElse(null));
        if (island == null) {
            FTBTeamIslands.LOGGER.info("No island or lobby found!");
            return;
        }
        island.teleportPlayerTo((ServerPlayer)event.getPlayer(), event.getPlayer().m_20194_());
    }
}

