/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamislands;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbteamislands.Config;
import dev.ftb.mods.ftbteamislands.islands.IslandsManager;
import dev.ftb.mods.ftbteamislands.islands.PrebuiltIslands;
import dev.ftb.mods.ftbteamislands.network.IslandSelectionPacket;
import dev.ftb.mods.ftbteamislands.network.NetworkManager;
import dev.ftb.mods.ftbteamislands.screens.IslandDirectoryScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ftbteamislands", value={Dist.CLIENT})
public class ClientHandler {
    public static PrebuiltIslands.PrebuiltIsland selectedIsland;

    public static void openSelectionGui(List<PrebuiltIslands> islands) {
        Minecraft.m_91087_().m_91152_((Screen)new IslandDirectoryScreen(islands, island -> NetworkManager.sendToServer(new IslandSelectionPacket(island.getStructureFileLocation(), island.yOffset()))));
    }

    @SubscribeEvent
    public static void screenEventPre(ScreenEvent.InitScreenEvent.Pre event) {
        if (IslandsManager.getAvailableIslands().size() == 0 || !((Boolean)Config.general.forceSinglePlayerIslandSelection.get()).booleanValue()) {
            return;
        }
        if (event.getScreen() instanceof CreateWorldScreen && selectedIsland == null) {
            Minecraft.m_91087_().m_91152_((Screen)new IslandDirectoryScreen(IslandsManager.getAvailableIslands(), island -> {
                selectedIsland = island;
                Minecraft.m_91087_().m_91152_((Screen)CreateWorldScreen.m_205424_(null));
            }));
        }
    }

    @SubscribeEvent
    public static void screenEventPost(ScreenEvent.InitScreenEvent.Post event) {
        Screen gui = event.getScreen();
        if (IslandsManager.getAvailableIslands().size() == 0 || !(gui instanceof CreateWorldScreen)) {
            return;
        }
        if (selectedIsland != null) {
            event.addListener((GuiEventListener)new Button(10, 74, 112, 20, (Component)new TextComponent("Select island"), b -> {
                selectedIsland = null;
                Minecraft.m_91087_().m_91152_((Screen)new IslandDirectoryScreen(IslandsManager.getAvailableIslands(), island -> {
                    selectedIsland = island;
                    Minecraft.m_91087_().m_91152_((Screen)CreateWorldScreen.m_205424_(null));
                }));
            }));
        }
    }

    @SubscribeEvent
    public static void screenRender(ScreenEvent.DrawScreenEvent.Post event) {
        if (!(event.getScreen() instanceof CreateWorldScreen)) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        if (selectedIsland != null) {
            PoseStack matrixStack = event.getPoseStack();
            RenderSystem.m_157456_((int)0, (ResourceLocation)selectedIsland.getImage());
            Screen.m_93133_((PoseStack)matrixStack, (int)10, (int)10, (float)0.0f, (float)0.0f, (int)112, (int)64, (int)112, (int)64);
            Screen.m_93172_((PoseStack)matrixStack, (int)10, (int)10, (int)122, (int)74, (int)-1828716544);
            matrixStack.m_85836_();
            matrixStack.m_85841_(0.8f, 0.8f, 0.8f);
            matrixStack.m_85837_(83.5, 20.0, 0.0);
            Screen.m_93208_((PoseStack)matrixStack, (Font)font, (String)"Selected island", (int)0, (int)0, (int)0xD1D1D1);
            matrixStack.m_85849_();
            MultiLineLabel.m_94341_((Font)font, (FormattedText)new TextComponent(selectedIsland.getName()), (int)100).m_6276_(matrixStack, 66, 28);
        }
    }
}

