/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import com.mojang.datafixers.util.Either;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.BooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StructureTask
extends BooleanTask {
    private static final ResourceLocation DEFAULT_STRUCTURE = new ResourceLocation("minecraft:mineshaft");
    private Either<ResourceKey<ConfiguredStructureFeature<?, ?>>, TagKey<ConfiguredStructureFeature<?, ?>>> structure = Either.left((Object)ResourceKey.m_135785_((ResourceKey)Registry.f_122882_, (ResourceLocation)DEFAULT_STRUCTURE));

    public StructureTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.STRUCTURE;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("structure", this.getStructure());
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.setStructure(nbt.m_128461_("structure"));
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130070_(this.getStructure());
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.setStructure(buffer.m_130136_(1024));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("structure", this.getStructure(), this::setStructure, "minecraft:mineshaft");
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return new TranslatableComponent("ftbquests.task.ftbquests.structure").m_130946_(": ").m_7220_((Component)new TextComponent(this.getStructure()).m_130940_(ChatFormatting.DARK_GREEN));
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    @Override
    public boolean canSubmit(TeamData teamData, ServerPlayer player) {
        ServerLevel level = (ServerLevel)player.f_19853_;
        return (Boolean)this.structure.map(key -> level.m_8595_().m_207791_(player.m_142538_(), key).m_73603_(), tag -> {
            Registry reg = (Registry)level.m_5962_().m_6632_(Registry.f_122882_).orElseThrow();
            for (Holder holder : reg.m_206058_(tag)) {
                if (!level.m_8595_().m_207817_(player.m_142538_(), (ConfiguredStructureFeature)holder.m_203334_()).m_73603_()) continue;
                return true;
            }
            return false;
        });
    }

    private void setStructure(String resLoc) {
        this.structure = resLoc.startsWith("#") ? Either.right((Object)TagKey.m_203882_((ResourceKey)Registry.f_122882_, (ResourceLocation)this.safeResourceLocation(resLoc.substring(1)))) : Either.left((Object)ResourceKey.m_135785_((ResourceKey)Registry.f_122882_, (ResourceLocation)this.safeResourceLocation(resLoc)));
    }

    private String getStructure() {
        return (String)this.structure.map(structure -> structure.m_135782_().toString(), tag -> "#" + tag.f_203868_().toString());
    }

    private ResourceLocation safeResourceLocation(String str) {
        try {
            return new ResourceLocation(str);
        }
        catch (ResourceLocationException e) {
            if (this.getQuestFile().isServerSide()) {
                FTBQuests.LOGGER.warn("Ignoring bad structure resource location '{}' for structure task {}", (Object)str, (Object)this.id);
            } else {
                FTBQuests.PROXY.getClientPlayer().m_5661_((Component)new TextComponent("Ignoring bad structure resource location: " + str).m_130940_(ChatFormatting.RED), false);
            }
            return DEFAULT_STRUCTURE;
        }
    }
}

