/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.architectury.core.RegistryEntry;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.gui.SelectQuestObjectScreen;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.reward.RandomReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public final class RewardType
extends RegistryEntry<RewardType> {
    public final ResourceLocation id;
    public final Provider provider;
    private final Supplier<Icon> icon;
    private Component displayName;
    private GuiProvider guiProvider;
    private boolean excludeFromListRewards = false;
    public int intId;

    @Nullable
    public static Reward createReward(Quest quest, String id) {
        if (((String)id).isEmpty()) {
            id = "ftbquests:item";
        } else if (((String)id).indexOf(58) == -1) {
            id = "ftbquests:" + (String)id;
        }
        RewardType type = RewardTypes.TYPES.get(new ResourceLocation((String)id));
        if (type == null) {
            return null;
        }
        return type.provider.create(quest);
    }

    public RewardType(ResourceLocation i, Provider p, Supplier<Icon> ic) {
        this.id = i;
        this.provider = p;
        this.icon = ic;
        this.displayName = null;
        this.guiProvider = (gui, quest, callback) -> {
            Reward reward = this.provider.create(quest);
            if (reward instanceof RandomReward) {
                RandomReward rnd = (RandomReward)reward;
                ConfigQuestObject config = new ConfigQuestObject(QuestObjectType.REWARD_TABLE);
                SelectQuestObjectScreen s = new SelectQuestObjectScreen(config, accepted -> {
                    if (accepted) {
                        rnd.table = (RewardTable)config.value;
                        callback.accept(reward);
                    }
                    gui.run();
                });
                s.setTitle((Component)new TranslatableComponent("ftbquests.gui.select_reward_table"));
                s.setHasSearchBox(true);
                s.openGui();
            } else {
                ConfigGroup group = new ConfigGroup("ftbquests");
                reward.getConfig(reward.createSubGroup(group));
                group.savedCallback = accepted -> {
                    if (accepted) {
                        callback.accept(reward);
                    }
                    gui.run();
                };
                new EditConfigScreen(group).openGui();
            }
        };
    }

    public String getTypeForNBT() {
        return this.id.m_135827_().equals("ftbquests") ? this.id.m_135815_() : this.id.toString();
    }

    public RewardType setDisplayName(Component name) {
        this.displayName = name;
        return this;
    }

    public Component getDisplayName() {
        if (this.displayName == null) {
            this.displayName = new TranslatableComponent("ftbquests.reward." + this.id.m_135827_() + "." + this.id.m_135815_());
        }
        return this.displayName;
    }

    public Icon getIcon() {
        return this.icon.get();
    }

    public RewardType setGuiProvider(GuiProvider p) {
        this.guiProvider = p;
        return this;
    }

    public GuiProvider getGuiProvider() {
        return this.guiProvider;
    }

    public RewardType setExcludeFromListRewards(boolean v) {
        this.excludeFromListRewards = v;
        return this;
    }

    public boolean getExcludeFromListRewards() {
        return this.excludeFromListRewards;
    }

    @FunctionalInterface
    public static interface Provider {
        public Reward create(Quest var1);
    }

    public static interface GuiProvider {
        @OnlyIn(value=Dist.CLIENT)
        public void openCreationGui(Runnable var1, Quest var2, Consumer<Reward> var3);
    }
}

