/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.ClaimRewardMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class Reward
extends QuestObjectBase {
    public final Quest quest;
    private Tristate team;
    protected RewardAutoClaim autoclaim;
    private boolean excludeFromClaimAll;
    private boolean ignoreRewardBlocking;

    public Reward(Quest q) {
        this.quest = q;
        this.team = Tristate.DEFAULT;
        this.autoclaim = RewardAutoClaim.DEFAULT;
        this.excludeFromClaimAll = this.getType().getExcludeFromListRewards();
        this.ignoreRewardBlocking = false;
    }

    @Override
    public final QuestObjectType getObjectType() {
        return QuestObjectType.REWARD;
    }

    @Override
    public final QuestFile getQuestFile() {
        return this.quest.chapter.file;
    }

    @Override
    @Nullable
    public final Chapter getQuestChapter() {
        return this.quest.chapter;
    }

    @Override
    public final long getParentID() {
        return this.quest.id;
    }

    public abstract RewardType getType();

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        if (this.team != Tristate.DEFAULT) {
            this.team.write(nbt, "team_reward");
        }
        if (this.autoclaim != RewardAutoClaim.DEFAULT) {
            nbt.m_128359_("auto", this.autoclaim.id);
        }
        if (this.excludeFromClaimAll) {
            nbt.m_128379_("exclude_from_claim_all", true);
        }
        if (this.ignoreRewardBlocking) {
            nbt.m_128379_("ignore_reward_blocking", true);
        }
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.team = Tristate.read((CompoundTag)nbt, (String)"team_reward");
        this.autoclaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP.get(nbt.m_128461_("auto")));
        this.excludeFromClaimAll = nbt.m_128471_("exclude_from_claim_all");
        this.ignoreRewardBlocking = nbt.m_128471_("ignore_reward_blocking");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        Tristate.NAME_MAP.write(buffer, (Object)this.team);
        RewardAutoClaim.NAME_MAP.write(buffer, (Object)this.autoclaim);
        buffer.writeBoolean(this.excludeFromClaimAll);
        buffer.writeBoolean(this.ignoreRewardBlocking);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.team = (Tristate)Tristate.NAME_MAP.read(buffer);
        this.autoclaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP.read(buffer));
        this.excludeFromClaimAll = buffer.readBoolean();
        this.ignoreRewardBlocking = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("team", (Object)this.team, v -> {
            this.team = v;
        }, Tristate.NAME_MAP).setNameKey("ftbquests.reward.team_reward");
        config.addEnum("autoclaim", (Object)this.autoclaim, v -> {
            this.autoclaim = v;
        }, RewardAutoClaim.NAME_MAP).setNameKey("ftbquests.reward.autoclaim");
        config.addBool("exclude_from_claim_all", this.getExcludeFromClaimAll(), v -> {
            this.excludeFromClaimAll = v;
        }, this.excludeFromClaimAll).setNameKey("ftbquests.reward.exclude_from_claim_all").setCanEdit(!this.isClaimAllHardcoded());
        config.addBool("ignore_reward_blocking", this.ignoreRewardBlocking(), v -> {
            this.ignoreRewardBlocking = v;
        }, this.ignoreRewardBlocking).setNameKey("ftbquests.quest.ignore_reward_blocking").setCanEdit(!this.isIgnoreRewardBlockingHardcoded());
    }

    public abstract void claim(ServerPlayer var1, boolean var2);

    public boolean automatedClaimPre(BlockEntity blockEntity, List<ItemStack> items, Random random, UUID playerId, @Nullable ServerPlayer player) {
        return player != null;
    }

    public void automatedClaimPost(BlockEntity blockEntity, UUID playerId, @Nullable ServerPlayer player) {
        if (player != null) {
            this.claim(player, false);
        }
    }

    @Override
    public final void deleteSelf() {
        this.quest.rewards.remove(this);
        for (TeamData data : this.getQuestFile().getAllData()) {
            data.deleteReward(this);
        }
        super.deleteSelf();
    }

    @Override
    public final void deleteChildren() {
        for (TeamData data : this.getQuestFile().getAllData()) {
            data.deleteReward(this);
        }
        super.deleteChildren();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null && gui.isViewingQuest()) {
            gui.viewQuestPanel.refreshWidgets();
        }
        if (gui != null) {
            gui.questPanel.refreshWidgets();
        }
    }

    @Override
    public void onCreated() {
        this.quest.rewards.add(this);
    }

    public final boolean isTeamReward() {
        return this.team.get(this.quest.chapter.file.defaultRewardTeam);
    }

    public final RewardAutoClaim getAutoClaimType() {
        if (this.quest.chapter.alwaysInvisible && (this.autoclaim == RewardAutoClaim.DEFAULT || this.autoclaim == RewardAutoClaim.DISABLED)) {
            return RewardAutoClaim.ENABLED;
        }
        if (this.autoclaim == RewardAutoClaim.DEFAULT) {
            return this.quest.chapter.file.defaultRewardAutoClaim;
        }
        return this.autoclaim;
    }

    @Override
    public final void forceProgress(TeamData teamData, ProgressChange progressChange) {
        if (progressChange.reset) {
            teamData.resetReward(progressChange.player, this);
        } else {
            teamData.claimReward(progressChange.player, this, progressChange.time.getTime());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        return this.getType().getIcon();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        return this.getType().getDisplayName();
    }

    @Override
    public final ConfigGroup createSubGroup(ConfigGroup group) {
        RewardType type = this.getType();
        return group.getGroup(this.getObjectType().id).getGroup(type.id.m_135827_()).getGroup(type.id.m_135815_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addTitleInMouseOverText() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        if (canClick) {
            button.playClickSound();
            new ClaimRewardMessage(this.id, true).sendToServer();
        }
    }

    public boolean getExcludeFromClaimAll() {
        return this.excludeFromClaimAll;
    }

    public boolean isClaimAllHardcoded() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Object getIngredient() {
        return this.getIcon().getIngredient();
    }

    @Override
    public final int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getButtonText() {
        return "";
    }

    public boolean ignoreRewardBlocking() {
        return this.ignoreRewardBlocking;
    }

    protected boolean isIgnoreRewardBlockingHardcoded() {
        return false;
    }
}

