/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import dev.ftb.mods.ftbquests.util.NetUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ChapterImage
implements Movable {
    public Chapter chapter;
    public double x;
    public double y;
    public double width;
    public double height;
    public double rotation;
    public Icon image;
    public List<String> hover;
    public String click;
    public boolean dev;
    public boolean corner;
    public Quest dependency;

    public ChapterImage(Chapter c) {
        this.chapter = c;
        this.y = 0.0;
        this.x = 0.0;
        this.width = 1.0;
        this.height = 1.0;
        this.rotation = 0.0;
        this.image = Icon.getIcon((String)"minecraft:textures/gui/presets/isles.png");
        this.hover = new ArrayList<String>();
        this.click = "";
        this.dev = false;
        this.corner = false;
        this.dependency = null;
    }

    public void writeData(CompoundTag nbt) {
        nbt.m_128347_("x", this.x);
        nbt.m_128347_("y", this.y);
        nbt.m_128347_("width", this.width);
        nbt.m_128347_("height", this.height);
        nbt.m_128347_("rotation", this.rotation);
        nbt.m_128359_("image", this.image.toString());
        ListTag hoverTag = new ListTag();
        for (String s : this.hover) {
            hoverTag.add((Object)StringTag.m_129297_((String)s));
        }
        nbt.m_128365_("hover", (Tag)hoverTag);
        nbt.m_128359_("click", this.click);
        nbt.m_128379_("dev", this.dev);
        nbt.m_128379_("corner", this.corner);
        if (this.dependency != null) {
            nbt.m_128359_("dependency", this.dependency.getCodeString());
        }
    }

    public void readData(CompoundTag nbt) {
        this.x = nbt.m_128459_("x");
        this.y = nbt.m_128459_("y");
        this.width = nbt.m_128459_("width");
        this.height = nbt.m_128459_("height");
        this.rotation = nbt.m_128459_("rotation");
        this.image = Icon.getIcon((String)nbt.m_128461_("image"));
        this.hover.clear();
        ListTag hoverTag = nbt.m_128437_("hover", 8);
        for (int i = 0; i < hoverTag.size(); ++i) {
            this.hover.add(hoverTag.m_128778_(i));
        }
        this.click = nbt.m_128461_("click");
        this.dev = nbt.m_128471_("dev");
        this.corner = nbt.m_128471_("corner");
        this.dependency = nbt.m_128441_("dependency") ? this.chapter.file.getQuest(this.chapter.file.getID(nbt.m_128423_("dependency"))) : null;
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.width);
        buffer.writeDouble(this.height);
        buffer.writeDouble(this.rotation);
        NetUtils.writeIcon(buffer, this.image);
        NetUtils.writeStrings(buffer, this.hover);
        buffer.m_130072_(this.click, Short.MAX_VALUE);
        buffer.writeBoolean(this.dev);
        buffer.writeBoolean(this.corner);
        buffer.writeLong(this.dependency == null ? 0L : this.dependency.id);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.width = buffer.readDouble();
        this.height = buffer.readDouble();
        this.rotation = buffer.readDouble();
        this.image = NetUtils.readIcon(buffer);
        NetUtils.readStrings(buffer, this.hover);
        this.click = buffer.m_130136_(Short.MAX_VALUE);
        this.dev = buffer.readBoolean();
        this.corner = buffer.readBoolean();
        this.dependency = this.chapter.file.getQuest(buffer.readLong());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        config.addDouble("x", this.x, v -> {
            this.x = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("y", this.y, v -> {
            this.y = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("width", this.width, v -> {
            this.width = v;
        }, 1.0, 0.0, Double.POSITIVE_INFINITY);
        config.addDouble("height", this.height, v -> {
            this.height = v;
        }, 1.0, 0.0, Double.POSITIVE_INFINITY);
        config.addDouble("rotation", this.rotation, v -> {
            this.rotation = v;
        }, 0.0, -180.0, 180.0);
        config.add("image", (ConfigValue)new ImageConfig(), (Object)this.image.toString(), v -> {
            this.image = Icon.getIcon((String)v);
        }, (Object)"minecraft:textures/gui/presets/isles.png");
        config.addList("hover", this.hover, (ConfigValue)new StringConfig(), (Object)"");
        config.addString("click", this.click, v -> {
            this.click = v;
        }, "");
        config.addBool("dev", this.dev, v -> {
            this.dev = v;
        }, false);
        config.addBool("corner", this.corner, v -> {
            this.corner = v;
        }, false);
        Predicate<QuestObjectBase> depTypes = object -> object == null || object instanceof Quest;
        ((ConfigQuestObject)config.add("dependency", new ConfigQuestObject(depTypes), (Object)this.dependency, v -> {
            this.dependency = v;
        }, null)).setNameKey("ftbquests.dependency");
    }

    @Override
    public long getMovableID() {
        return 0L;
    }

    @Override
    public Chapter getChapter() {
        return this.chapter;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public String getShape() {
        return "square";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void move(Chapter to, double _x, double _y) {
        this.x = _x;
        this.y = _y;
        if (to != this.chapter) {
            this.chapter.images.remove(this);
            new EditObjectMessage(this.chapter).sendToServer();
            this.chapter = to;
            this.chapter.images.add(this);
        }
        new EditObjectMessage(this.chapter).sendToServer();
    }

    @Override
    public void onMoved(double x, double y, long chapterId) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawMoved(PoseStack matrixStack) {
        matrixStack.m_85836_();
        if (this.corner) {
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)this.rotation));
            this.image.withColor(Color4I.WHITE.withAlpha(50)).draw(matrixStack, 0, 0, 1, 1);
        } else {
            matrixStack.m_85837_(0.5, 0.5, 0.0);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)this.rotation));
            matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
            this.image.withColor(Color4I.WHITE.withAlpha(50)).draw(matrixStack, -1, -1, 2, 2);
        }
        matrixStack.m_85849_();
        QuestShape.get((String)this.getShape()).outline.withColor(Color4I.WHITE.withAlpha(30)).draw(matrixStack, 0, 0, 1, 1);
    }
}

