/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.math.PixelBuffer;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.quests.ContextMenuBuilder;
import dev.ftb.mods.ftbquests.gui.quests.QuestPositionableButton;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.gui.quests.TooltipContextMenuItem;
import dev.ftb.mods.ftbquests.net.CreateObjectMessage;
import dev.ftb.mods.ftbquests.net.DeleteObjectMessage;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.ChapterImage;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.ProgressionMode;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestLink;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.Nullable;

public class QuestButton
extends Button
implements QuestPositionableButton {
    public QuestScreen questScreen;
    public Quest quest;
    private Collection<QuestButton> dependencies = null;

    public QuestButton(Panel panel, Quest q) {
        super(panel, q.getTitle(), q.getIcon());
        this.questScreen = (QuestScreen)panel.getGui();
        this.setSize(20, 20);
        this.quest = q;
    }

    public boolean isEnabled() {
        return this.questScreen.file.canEdit() || this.quest.isVisible(this.questScreen.file.self);
    }

    public boolean shouldDraw() {
        return this.questScreen.file.canEdit() || this.quest.isVisible(this.questScreen.file.self);
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (!this.shouldDraw() || this.questScreen.movingObjects || this.questScreen.viewQuestPanel.isMouseOver() || this.questScreen.chapterPanel.isMouseOver()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void updateMouseOver(int mouseX, int mouseY) {
        super.updateMouseOver(mouseX, mouseY);
        if (this.questScreen.questPanel.mouseOverQuest != null && this.questScreen.questPanel.mouseOverQuest != this) {
            this.isMouseOver = false;
        }
        if (this.isMouseOver) {
            QuestShape shape = QuestShape.get(this.quest.getShape());
            int ax = this.getX();
            int ay = this.getY();
            double relX = (double)(mouseX - ax) / (double)this.width;
            double relY = (double)(mouseY - ay) / (double)this.height;
            PixelBuffer pixelBuffer = shape.getShapePixels();
            int rx = (int)(relX * (double)pixelBuffer.getWidth());
            int ry = (int)(relY * (double)pixelBuffer.getHeight());
            if (rx < 0 || ry < 0 || rx >= pixelBuffer.getWidth() || ry >= pixelBuffer.getHeight()) {
                this.isMouseOver = false;
            } else {
                int a = pixelBuffer.getRGB(rx, ry) >> 24 & 0xFF;
                if (a < 5) {
                    this.isMouseOver = false;
                }
            }
        }
        if (this.isMouseOver && this.questScreen.questPanel.mouseOverQuest == null) {
            this.questScreen.questPanel.mouseOverQuest = this;
        }
    }

    public Collection<QuestButton> getDependencies() {
        if (this.dependencies == null) {
            ArrayList list = new ArrayList();
            this.quest.getDependencies().forEach(dependency -> {
                if (!dependency.invalid && dependency instanceof Quest) {
                    for (Widget widget : this.questScreen.questPanel.widgets) {
                        if (!(widget instanceof QuestButton)) continue;
                        QuestButton qb = (QuestButton)widget;
                        if (dependency != qb.quest) continue;
                        list.add(qb);
                    }
                }
            });
            this.dependencies = List.copyOf(list);
        }
        return this.dependencies;
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        if (this.questScreen.file.canEdit() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            Collection<Quest> selected = this.questScreen.getSelectedQuests();
            if (!selected.isEmpty()) {
                if (!selected.contains(this.quest)) {
                    contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("ftbquests.gui.add_dependencies"), (Icon)ThemeProperties.ADD_ICON.get(), () -> selected.forEach(q -> this.editDependency(this.quest, (QuestObject)q, true))));
                    contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("ftbquests.gui.remove_dependencies"), (Icon)ThemeProperties.DELETE_ICON.get(), () -> selected.forEach(q -> this.editDependency(this.quest, (QuestObject)q, false))));
                    contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("ftbquests.gui.add_dependencies_self"), (Icon)ThemeProperties.ADD_ICON.get(), () -> selected.forEach(q -> this.editDependency((Quest)q, this.quest, true))));
                    contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("ftbquests.gui.remove_dependencies_self"), (Icon)ThemeProperties.DELETE_ICON.get(), () -> selected.forEach(q -> this.editDependency((Quest)q, this.quest, false))));
                } else {
                    contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("gui.move"), (Icon)ThemeProperties.MOVE_UP_ICON.get(this.quest), () -> {
                        this.questScreen.movingObjects = true;
                    }));
                    contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("ftbquests.gui.add_reward_all"), (Icon)ThemeProperties.ADD_ICON.get(this.quest), this::openAddRewardContextMenu));
                    contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("ftbquests.gui.clear_reward_all"), (Icon)ThemeProperties.CLOSE_ICON.get(this.quest), () -> selected.forEach(q -> q.rewards.forEach(r -> new DeleteObjectMessage(r.id).sendToServer()))));
                    contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("selectServer.delete"), (Icon)ThemeProperties.DELETE_ICON.get(this.quest), this::deleteSelectedObjects).setYesNo((Component)new TranslatableComponent("delete_item", new Object[]{new TranslatableComponent("ftbquests.quests").m_130946_(" [" + this.questScreen.selectedObjects.size() + "]")})));
                }
                contextMenu.add(ContextMenuItem.SEPARATOR);
                contextMenu.add(new ContextMenuItem((Component)new TextComponent("Ctrl+A to select all quests").m_130940_(ChatFormatting.GRAY), Icons.INFO, null).setCloseMenu(false));
                contextMenu.add(new ContextMenuItem((Component)new TextComponent("Ctrl+D to deselect all quests").m_130940_(ChatFormatting.GRAY), Icons.INFO, null).setCloseMenu(false));
                contextMenu.add(new ContextMenuItem((Component)new TextComponent("Ctrl+Arrow Key to move selected quests").m_130940_(ChatFormatting.GRAY), Icons.INFO, null).setCloseMenu(false));
                this.getGui().openContextMenu(contextMenu);
            } else {
                ContextMenuBuilder.create(this.theQuestObject(), this.questScreen).withDeletionFocus(this.moveAndDeleteFocus()).insertAtTop(List.of(new TooltipContextMenuItem((Component)new TranslatableComponent("gui.move"), (Icon)ThemeProperties.MOVE_UP_ICON.get(this.quest), () -> {
                    this.questScreen.movingObjects = true;
                    this.questScreen.selectedObjects.clear();
                    this.questScreen.toggleSelected(this.moveAndDeleteFocus());
                }, new Component[]{new TranslatableComponent("ftbquests.gui.move_tooltip").m_130940_(ChatFormatting.DARK_GRAY)}))).openContextMenu(this.getGui());
            }
        } else if (button.isLeft()) {
            if (QuestButton.isCtrlKeyDown() && this.questScreen.file.canEdit()) {
                if (this.questScreen.isViewingQuest()) {
                    this.questScreen.closeQuest();
                }
                this.questScreen.toggleSelected(this.moveAndDeleteFocus());
            } else if (!this.quest.guidePage.isEmpty() && this.quest.tasks.isEmpty() && this.quest.rewards.isEmpty() && this.quest.getDescription().length == 0) {
                this.handleClick("guide", this.quest.guidePage);
            } else if (this.questScreen.file.canEdit() || !this.quest.hideDetailsUntilStartable() || this.questScreen.file.self.canStartTasks(this.quest)) {
                this.questScreen.open(this.theQuestObject(), false);
            }
        } else if (this.questScreen.file.canEdit() && button.isMiddle()) {
            if (!this.questScreen.selectedObjects.contains(this.moveAndDeleteFocus())) {
                this.questScreen.toggleSelected(this.moveAndDeleteFocus());
            }
            this.questScreen.movingObjects = true;
        } else if (button.isRight()) {
            this.questScreen.movingObjects = false;
            if (this.questScreen.getViewedQuest() != this.quest) {
                this.questScreen.viewQuestPanel.hidePanel = true;
                this.questScreen.viewQuest(this.quest);
            } else {
                this.questScreen.closeQuest();
            }
        }
    }

    private void openAddRewardContextMenu() {
        ArrayList<ContextMenuItem> contextMenu2 = new ArrayList<ContextMenuItem>();
        for (RewardType type : RewardTypes.TYPES.values()) {
            contextMenu2.add(new ContextMenuItem(type.getDisplayName(), type.getIcon(), () -> {
                this.playClickSound();
                type.getGuiProvider().openCreationGui((Runnable)((Object)this), this.quest, reward -> this.questScreen.getSelectedQuests().forEach(quest -> {
                    Reward r = type.provider.create((Quest)quest);
                    CompoundTag nbt1 = new CompoundTag();
                    reward.writeData(nbt1);
                    r.readData(nbt1);
                    CompoundTag extra = new CompoundTag();
                    extra.m_128359_("type", type.getTypeForNBT());
                    new CreateObjectMessage(r, extra).sendToServer();
                }));
            }));
        }
        this.getGui().openContextMenu(contextMenu2);
    }

    private void deleteSelectedObjects() {
        this.questScreen.selectedObjects.forEach(movable -> {
            if (movable instanceof Quest) {
                Quest q = (Quest)movable;
                this.questScreen.file.deleteObject(q.id);
            } else if (movable instanceof QuestLink) {
                QuestLink ql = (QuestLink)movable;
                this.questScreen.file.deleteObject(ql.id);
            } else if (movable instanceof ChapterImage) {
                ChapterImage img = (ChapterImage)movable;
                img.chapter.images.remove(movable);
                new EditObjectMessage(img.chapter).sendToServer();
            }
        });
        this.questScreen.selectedObjects.clear();
    }

    private void editDependency(Quest quest, QuestObject object, boolean add) {
        List<QuestObject> prevDeps = quest.getDependencies().toList();
        if (add != quest.hasDependency(object)) {
            if (add) {
                quest.addDependency(object);
            } else {
                quest.removeDependency(object);
            }
        }
        quest.removeInvalidDependencies();
        if (quest.verifyDependencies(false)) {
            new EditObjectMessage(quest).sendToServer();
            this.questScreen.questPanel.refreshWidgets();
        } else {
            quest.clearDependencies();
            prevDeps.forEach(quest::addDependency);
            QuestScreen.displayError((Component)new TranslatableComponent("ftbquests.gui.looping_dependencies"));
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.quest.tasks.size() == 1 ? this.quest.tasks.get(0).getIngredient() : null;
    }

    public void addMouseOverText(TooltipList list) {
        this.questScreen.addInfoTooltip(list, this.quest);
        Component title = this.getTitle();
        if (this.questScreen.file.self != null && this.questScreen.file.self.isStarted(this.quest) && !this.questScreen.file.self.isCompleted(this.quest)) {
            title = title.m_6881_().m_7220_((Component)new TextComponent(" " + this.questScreen.file.self.getRelativeProgress(this.quest) + "%").m_130940_(ChatFormatting.DARK_GRAY));
        }
        list.add(title);
        Component description = this.quest.getSubtitle();
        if (description != TextComponent.f_131282_) {
            list.add((Component)new TextComponent("").m_7220_(description).m_130940_(ChatFormatting.GRAY));
        }
        if (this.quest.optional) {
            list.add((Component)new TextComponent("[").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TranslatableComponent("ftbquests.quest.optional")).m_130946_("]"));
        }
        if (this.quest.canRepeat) {
            list.add((Component)new TranslatableComponent("ftbquests.quest.can_repeat").m_130940_(ChatFormatting.GRAY));
        }
        if (!this.questScreen.file.self.canStartTasks(this.quest)) {
            list.add((Component)new TextComponent("[").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TranslatableComponent("ftbquests.quest.locked")).m_130946_("]"));
        }
    }

    public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        float s;
        boolean canStart;
        Color4I outlineColor = (Color4I)ThemeProperties.QUEST_NOT_STARTED_COLOR.get(this.quest);
        Object questIcon = Icon.EMPTY;
        Color4I hiddenIcon = Icon.EMPTY;
        TeamData teamData = this.questScreen.file.self;
        boolean isCompleted = teamData.isCompleted(this.quest);
        boolean isStarted = isCompleted || teamData.isStarted(this.quest);
        boolean bl = canStart = isCompleted || isStarted || teamData.areDependenciesComplete(this.quest);
        if (canStart) {
            if (isCompleted) {
                questIcon = teamData.hasUnclaimedRewards(Minecraft.m_91087_().f_91074_.m_142081_(), this.quest) ? (Icon)ThemeProperties.ALERT_ICON.get(this.quest) : (teamData.isQuestPinned(this.quest.id) ? (Icon)ThemeProperties.PIN_ICON_ON.get() : (Icon)ThemeProperties.CHECK_ICON.get(this.quest));
                outlineColor = (Color4I)ThemeProperties.QUEST_COMPLETED_COLOR.get(this.quest);
            } else if (isStarted) {
                outlineColor = (Color4I)ThemeProperties.QUEST_STARTED_COLOR.get(this.quest);
                if (this.quest.getProgressionMode() == ProgressionMode.FLEXIBLE && this.quest.allTasksCompleted(teamData)) {
                    questIcon = new ThemeProperties.CheckIcon(Color4I.rgb((int)0x606060), Color4I.rgb((int)0x808080));
                }
            }
        } else {
            outlineColor = (Color4I)ThemeProperties.QUEST_LOCKED_COLOR.get(this.quest);
        }
        if (questIcon == Icon.EMPTY && teamData.isQuestPinned(this.quest.id)) {
            questIcon = (Icon)ThemeProperties.PIN_ICON_ON.get();
        }
        if (this.questScreen.file.canEdit() && !this.quest.isVisible(teamData)) {
            hiddenIcon = (Icon)ThemeProperties.HIDDEN_ICON.get();
        }
        QuestShape shape = QuestShape.get(this.getShape());
        shape.shape.withColor(Color4I.DARK_GRAY).draw(matrixStack, x, y, w, h);
        shape.background.withColor(Color4I.WHITE.withAlpha(150)).draw(matrixStack, x, y, w, h);
        shape.outline.withColor(outlineColor).draw(matrixStack, x, y, w, h);
        if (!this.icon.isEmpty()) {
            s = (float)w * 2.0f / 3.0f;
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)x + (double)((float)w - s) / 2.0, (double)y + (double)((float)h - s) / 2.0, 0.0);
            matrixStack.m_85841_(s, s, 1.0f);
            this.icon.draw(matrixStack, 0, 0, 1, 1);
            matrixStack.m_85849_();
        }
        GuiHelper.setupDrawing();
        if (this.quest == this.questScreen.viewQuestPanel.quest || this.questScreen.selectedObjects.contains(this.moveAndDeleteFocus())) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, 200.0);
            Color4I col = Color4I.WHITE.withAlpha((int)(190.0 + Math.sin((double)System.currentTimeMillis() * 0.003) * 50.0));
            shape.outline.withColor(col).draw(matrixStack, x, y, w, h);
            shape.background.withColor(col).draw(matrixStack, x, y, w, h);
            matrixStack.m_85849_();
        }
        if (!canStart) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, 200.0);
            shape.shape.withColor(Color4I.BLACK.withAlpha(100)).draw(matrixStack, x, y, w, h);
            matrixStack.m_85849_();
        }
        if (this.isMouseOver()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, 200.0);
            shape.shape.withColor(Color4I.WHITE.withAlpha(100)).draw(matrixStack, x, y, w, h);
            matrixStack.m_85849_();
        }
        if (!questIcon.isEmpty()) {
            s = (float)w / 8.0f * 3.0f;
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)((float)(x + w) - s), (double)y, 200.0);
            matrixStack.m_85841_(s, s, 1.0f);
            questIcon.draw(matrixStack, 0, 0, 1, 1);
            matrixStack.m_85849_();
        }
        if (!hiddenIcon.isEmpty()) {
            s = (float)w / 8.0f * 3.0f;
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)x, (double)y, 200.0);
            matrixStack.m_85841_(s, s, 1.0f);
            hiddenIcon.draw(matrixStack, 0, 0, 1, 1);
            matrixStack.m_85849_();
        }
    }

    protected String getShape() {
        return this.quest.getShape();
    }

    @Override
    public QuestPositionableButton.Position getPosition() {
        return new QuestPositionableButton.Position(this.quest.x, this.quest.y, this.quest.size, this.quest.size);
    }

    protected QuestObject theQuestObject() {
        return this.quest;
    }

    public Movable moveAndDeleteFocus() {
        return (Movable)((Object)this.theQuestObject());
    }
}

