/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.forge;

import dev.ftb.mods.ftbquests.block.TaskScreenBlock;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.FluidTask;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.forge.ForgeEnergyTask;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeTaskScreenBlockEntity
extends TaskScreenBlockEntity {
    private AABB cachedRenderAABB = null;
    private final LazyOptional<IItemHandler> itemCap = LazyOptional.of(() -> new TaskItemHandler());
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> new TaskFluidHandler());
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> new TaskForgeEnergyHandler());

    public ForgeTaskScreenBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
    }

    public AABB getRenderBoundingBox() {
        if (this.cachedRenderAABB == null) {
            TaskScreenBlock tsb;
            AABB box = super.getRenderBoundingBox();
            Block block = this.m_58900_().m_60734_();
            this.cachedRenderAABB = !(block instanceof TaskScreenBlock) || (tsb = (TaskScreenBlock)block).getSize() == 1 ? box : box.m_82400_((double)tsb.getSize());
        }
        return this.cachedRenderAABB;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCap.invalidate();
        this.fluidCap.invalidate();
        this.energyCap.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemCap.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    private class TaskForgeEnergyHandler
    implements IEnergyStorage {
        private TaskForgeEnergyHandler() {
        }

        public int receiveEnergy(int amount, boolean simulate) {
            Task task = ForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof ForgeEnergyTask) {
                ForgeEnergyTask task2 = (ForgeEnergyTask)task;
                TeamData data = ForgeTaskScreenBlockEntity.this.getCachedTeamData();
                if (data != null && data.canStartTasks(task2.quest) && !data.isCompleted(task2)) {
                    long space = task2.getMaxProgress() - data.getProgress(task2);
                    long toAdd = Math.min(task2.maxInput, Math.min((long)amount, space));
                    if (!simulate) {
                        data.addProgress(task2, toAdd);
                    }
                    return (int)toAdd;
                }
            }
            return 0;
        }

        public int extractEnergy(int amount, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            int n;
            Task task = ForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof ForgeEnergyTask) {
                ForgeEnergyTask task2 = (ForgeEnergyTask)task;
                n = (int)ForgeTaskScreenBlockEntity.this.getCachedTeamData().getProgress(task2);
            } else {
                n = 0;
            }
            return n;
        }

        public int getMaxEnergyStored() {
            int n;
            Task task = ForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof ForgeEnergyTask) {
                ForgeEnergyTask task2 = (ForgeEnergyTask)task;
                n = (int)task2.value;
            } else {
                n = 0;
            }
            return n;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }

    private class TaskFluidHandler
    implements IFluidHandler {
        private TaskFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            FluidStack fluidStack;
            Task task;
            if (tank == 0 && (task = ForgeTaskScreenBlockEntity.this.getTask()) instanceof FluidTask) {
                FluidTask task2 = (FluidTask)task;
                fluidStack = new FluidStack(task2.fluid, (int)ForgeTaskScreenBlockEntity.this.getCachedTeamData().getProgress(task2));
            } else {
                fluidStack = FluidStack.EMPTY;
            }
            return fluidStack;
        }

        public int getTankCapacity(int tank) {
            int n;
            Task task;
            if (tank == 0 && (task = ForgeTaskScreenBlockEntity.this.getTask()) instanceof FluidTask) {
                FluidTask task2 = (FluidTask)task;
                n = (int)task2.getMaxProgress();
            } else {
                n = 0;
            }
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isFluidValid(int tank, @NotNull FluidStack fluidStack) {
            if (tank != 0) return false;
            Task task = ForgeTaskScreenBlockEntity.this.getTask();
            if (!(task instanceof FluidTask)) return false;
            FluidTask task2 = (FluidTask)task;
            if (task2.fluid != fluidStack.getFluid()) return false;
            if (task2.fluidNBT == null) return true;
            if (!task2.fluidNBT.equals((Object)fluidStack.getTag())) return false;
            return true;
        }

        public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            Task task = ForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof FluidTask) {
                FluidTask task2 = (FluidTask)task;
                TeamData data = ForgeTaskScreenBlockEntity.this.getCachedTeamData();
                if (data != null && data.canStartTasks(task2.quest) && !data.isCompleted(task2)) {
                    long space = task2.getMaxProgress() - data.getProgress(task2);
                    long toAdd = Math.min((long)fluidStack.getAmount(), space);
                    if (fluidAction.execute()) {
                        data.addProgress(task2, Math.min((long)fluidStack.getAmount(), toAdd));
                    }
                    return (int)toAdd;
                }
            }
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            FluidStack fluidStack2;
            Task task = ForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof FluidTask) {
                FluidTask task2 = (FluidTask)task;
                if (fluidStack.getFluid() == task2.fluid) {
                    fluidStack2 = this.drain(fluidStack.getAmount(), fluidAction);
                    return fluidStack2;
                }
            }
            fluidStack2 = FluidStack.EMPTY;
            return fluidStack2;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction fluidAction) {
            Task task = ForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof FluidTask) {
                FluidTask task2 = (FluidTask)task;
                TeamData data = ForgeTaskScreenBlockEntity.this.getCachedTeamData();
                if (data != null && data.canStartTasks(task2.quest) && !data.isCompleted(task2)) {
                    long toTake = Math.min((long)maxDrain, data.getProgress(task2));
                    if (fluidAction.execute()) {
                        data.addProgress(task2, -toTake);
                    }
                    FluidStack result = new FluidStack(task2.fluid, (int)toTake);
                    if (task2.fluidNBT != null) {
                        result.setTag(task2.fluidNBT.m_6426_());
                    }
                    return result;
                }
            }
            return FluidStack.EMPTY;
        }
    }

    private class TaskItemHandler
    implements IItemHandler {
        private TaskItemHandler() {
        }

        public int getSlots() {
            return 2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public ItemStack getStackInSlot(int slot) {
            ItemStack itemStack;
            Task task = ForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof ItemTask) {
                ItemTask t = (ItemTask)task;
                if (slot == 0) {
                    itemStack = ItemHandlerHelper.copyStackWithSize((ItemStack)t.item, (int)((int)Math.min(ForgeTaskScreenBlockEntity.this.getCachedTeamData().getProgress(t), (long)t.item.m_41741_())));
                    return itemStack;
                }
            }
            itemStack = ItemStack.f_41583_;
            return itemStack;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            TeamData data = ForgeTaskScreenBlockEntity.this.getCachedTeamData();
            Task task = ForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof ItemTask) {
                ItemTask task2 = (ItemTask)task;
                if (data.canStartTasks(task2.quest)) {
                    return task2.insert(data, stack, simulate);
                }
            }
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int count, boolean simulate) {
            Task task;
            if (!ForgeTaskScreenBlockEntity.this.isInputOnly() && (task = ForgeTaskScreenBlockEntity.this.getTask()) instanceof ItemTask) {
                TeamData data;
                ItemTask task2 = (ItemTask)task;
                if (!ItemFiltersAPI.isFilter((ItemStack)task2.item) && (data = ForgeTaskScreenBlockEntity.this.getCachedTeamData()) != null && data.canStartTasks(task2.quest) && !data.isCompleted(task2)) {
                    int itemsRemoved = (int)Math.min(data.getProgress(task2), (long)count);
                    if (!simulate) {
                        data.addProgress(task2, -itemsRemoved);
                    }
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)task2.item, (int)itemsRemoved);
                }
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            int n;
            Task task = ForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof ItemTask) {
                ItemTask itemTask = (ItemTask)task;
                n = itemTask.item.m_41741_();
            } else {
                n = 0;
            }
            return n;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            ItemTask t;
            Task task = ForgeTaskScreenBlockEntity.this.getTask();
            return task instanceof ItemTask && (t = (ItemTask)task).test(stack);
        }
    }
}

